/*
 * Decompiled with CFR 0.152.
 */
package kr.floware;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Date;

public class DateTime {
    private static final ZoneId LOCAL_ZONE = ZoneId.systemDefault();
    private static volatile String DEFAULT_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private Instant instant;
    private DateTimeFormatter custom;

    private DateTime() {
    }

    public static synchronized void setDefaultFormat(String format) {
        DEFAULT_FORMAT = format;
    }

    public static DateTime now() {
        return DateTime.from(Instant.now());
    }

    public static DateTime from(Date date) {
        return DateTime.from(date.toInstant());
    }

    public static DateTime from(Instant instant) {
        DateTime dt = new DateTime();
        dt.instant = instant;
        return dt;
    }

    public static DateTime from(String dateStr, String format) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
        if (format.contains("H") || format.contains("m") || format.contains("s")) {
            LocalDateTime ldt = LocalDateTime.parse(dateStr, formatter);
            return DateTime.from(ldt.atZone(LOCAL_ZONE).toInstant());
        }
        LocalDate ld = LocalDate.parse(dateStr, formatter);
        return DateTime.from(ld.atStartOfDay(LOCAL_ZONE).toInstant());
    }

    public DateTime addHours(int hours) {
        this.instant = this.instant.plus((long)hours, ChronoUnit.HOURS);
        return this;
    }

    public DateTime addDays(int days) {
        this.instant = this.instant.plus((long)days, ChronoUnit.DAYS);
        return this;
    }

    public DateTime addMonths(int months) {
        ZonedDateTime zdt = ZonedDateTime.ofInstant(this.instant, LOCAL_ZONE);
        zdt = zdt.plusMonths(months);
        this.instant = zdt.toInstant();
        return this;
    }

    public DateTime beginOfHour() {
        this.instant = this.instant.truncatedTo(ChronoUnit.HOURS);
        return this;
    }

    public DateTime beginOfDay() {
        this.instant = ZonedDateTime.ofInstant(this.instant, LOCAL_ZONE).toLocalDate().atStartOfDay(LOCAL_ZONE).toInstant();
        return this;
    }

    public DateTime endOfHour() {
        this.instant = this.instant.truncatedTo(ChronoUnit.HOURS).plus(1L, ChronoUnit.HOURS).minusMillis(1L);
        return this;
    }

    public DateTime endOfDay() {
        LocalDateTime endOfDay = ZonedDateTime.ofInstant(this.instant, LOCAL_ZONE).toLocalDate().atTime(LocalTime.MAX);
        this.instant = endOfDay.atZone(LOCAL_ZONE).toInstant();
        return this;
    }

    public Instant toInstant() {
        return this.instant;
    }

    public Date toDate() {
        return Date.from(this.instant);
    }

    public DateTime setFormat(String format) {
        this.custom = DateTimeFormatter.ofPattern(format);
        return this;
    }

    public String toString() {
        DateTimeFormatter fmt = this.custom == null ? DateTimeFormatter.ofPattern(DEFAULT_FORMAT) : this.custom;
        return ZonedDateTime.ofInstant(this.instant, LOCAL_ZONE).format(fmt);
    }
}

