/*
 * Decompiled with CFR 0.152.
 */
package kr.floware;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPool {
    private ExecutorService executor;

    private ThreadPool() {
    }

    public static ThreadPool ofFixed(int poolSize) {
        ThreadPool pool = new ThreadPool();
        pool.executor = Executors.newFixedThreadPool(poolSize);
        return pool;
    }

    public static ThreadPool ofCached(int keepAliveMinutes) {
        ThreadPool pool = new ThreadPool();
        ThreadPoolExecutor tpe = (ThreadPoolExecutor)Executors.newCachedThreadPool();
        tpe.setKeepAliveTime(keepAliveMinutes, TimeUnit.MINUTES);
        tpe.allowCoreThreadTimeOut(true);
        pool.executor = tpe;
        return pool;
    }

    public void execute(Runnable task) {
        this.getExecutor().execute(task);
    }

    public <T> List<Future<T>> waitAll(Collection<? extends Callable<T>> tasks) {
        try {
            return this.getExecutor().invokeAll(tasks);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("waitAll interrupted", e);
        }
    }

    public <T> T waitAny(Collection<? extends Callable<T>> tasks) {
        try {
            return this.getExecutor().invokeAny(tasks);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("waitAny interrupted", e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("waitAny execution failed", e.getCause());
        }
    }

    public void shutdown() {
        this.getExecutor().shutdown();
    }

    public void shutdownNow() {
        this.getExecutor().shutdownNow();
    }

    private ThreadPoolExecutor getExecutor() {
        return (ThreadPoolExecutor)this.executor;
    }

    public int getActiveCount() {
        return this.getExecutor().getActiveCount();
    }

    public int getPoolSize() {
        return this.getExecutor().getPoolSize();
    }

    public int getQueueSize() {
        return this.getExecutor().getQueue().size();
    }
}

