/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.concurrent;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kr.floware.logging.Logger;

public class BoundQueue<T> {
    private static Logger logger = Logger.getLogger();
    private LinkedBlockingQueue<T> queue = new LinkedBlockingQueue();
    Thread dequeueThread;

    public void enqueue(T o) {
        try {
            this.queue.put(o);
        }
        catch (InterruptedException e) {
            logger.d("BoundQueue enqueue " + e);
        }
    }

    public T dequeueThrow() throws InterruptedException {
        this.dequeueThread = Thread.currentThread();
        return this.queue.take();
    }

    public T dequeue() {
        try {
            return this.dequeueThrow();
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    public T dequeue(int ms) {
        try {
            this.dequeueThread = Thread.currentThread();
            return this.queue.poll(ms, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    public void clear() {
        this.queue.clear();
    }

    public List<T> pickAll() {
        return Arrays.stream(this.queue.toArray()).map(x -> x).collect(Collectors.toList());
    }

    public List<T> drainAll() {
        ArrayList list = new ArrayList();
        this.queue.drainTo(list);
        return list;
    }

    public int size() {
        return this.queue.size();
    }

    public boolean isEmpty() {
        return 0 == this.size();
    }
}

