/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class Monitor {
    private ReentrantLock reentrantLock = new ReentrantLock();

    public Condition newCondition() {
        return this.reentrantLock.newCondition();
    }

    public void lock() {
        this.reentrantLock.lock();
    }

    public boolean isLocked() {
        return this.reentrantLock.isLocked();
    }

    public int getWaitThCount(Condition cd) {
        return this.reentrantLock.getWaitQueueLength(cd);
    }

    public boolean isHeldCurrentThread() {
        return this.reentrantLock.isHeldByCurrentThread();
    }

    public void unlock() {
        this.reentrantLock.unlock();
    }

    public void signal(Condition cd) {
        cd.signal();
    }

    public void signalAll(Condition cd) {
        cd.signalAll();
    }

    public boolean await(Condition cd) throws InterruptedException {
        return this.await(cd, Integer.MAX_VALUE);
    }

    public boolean await(Condition cd, int secondTimeout) throws InterruptedException {
        return cd.await(secondTimeout, TimeUnit.SECONDS);
    }

    public boolean quietAwait(Condition cd, int secondTimeout) {
        try {
            return cd.await(secondTimeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            return true;
        }
    }

    public void quietAwait(Condition cd) {
        cd.awaitUninterruptibly();
    }
}

