/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.concurrent;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kr.floware.logging.Logger;
import kr.floware.utils.Assert;
import kr.floware.utils.ClassUtils;
import kr.floware.utils.StringUtils;

public class ThreadUtils {
    private static Logger logger = Logger.getLogger();
    private static Executor pool;
    public static boolean ThBgMode;

    private ThreadUtils() {
    }

    public static void initFixedPool(int size) {
        Assert.isNull(pool, "ThreadPool already inited", new Object[0]);
        pool = Executors.newFixedThreadPool(size);
    }

    public static void initPool(int minute) {
        Assert.isNull(pool, "ThreadPool already inited", new Object[0]);
        pool = Executors.newCachedThreadPool();
        ThreadUtils.getPool().setKeepAliveTime(minute, TimeUnit.MINUTES);
    }

    public static ThreadPoolExecutor getPool() {
        return (ThreadPoolExecutor)pool;
    }

    public static void invokePool(Object target, String method, Object ... args) {
        ThreadUtils.invokePool(null, target, method, args);
    }

    public static void invokePool(String thName, Object target, String method, Object ... args) {
        Assert.notNull(pool, "Need initPool or initFixedPool", new Object[0]);
        ThreadUtils.invokePool(ThreadUtils.invokeEx(thName, target, method, args));
    }

    public static void invokePool(Runnable command) {
        Assert.notNull(pool, "Need initPool or initFixedPool", new Object[0]);
        pool.execute(command);
    }

    @Deprecated
    public static Thread invoke(Runnable command) {
        return ThreadUtils.invoke("", command);
    }

    @Deprecated
    public static Thread invoke(String thName, Runnable command) {
        Thread th = new Thread(command);
        th.setDaemon(ThBgMode);
        if (!StringUtils.nullOrEmpty(thName)) {
            th.setName(thName);
        }
        th.start();
        return th;
    }

    public static Thread invoke(Object target, String method, Object ... args) {
        return ThreadUtils.invoke(null, target, method, args);
    }

    public static Thread invoke(String thName, Object target, String method, Object ... args) {
        return ThreadUtils.invoke(ThreadUtils.invokeEx(thName, target, method, args));
    }

    private static Runnable invokeEx(final String thName, final Object target, final String method, final Object ... args) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    if (!StringUtils.nullOrEmpty(thName)) {
                        ThreadUtils.chgName(thName);
                    }
                    ClassUtils.invoke(target, method, args);
                }
                catch (Exception e) {
                    logger.e(e);
                }
            }
        };
    }

    public static void interrupt(Thread thread) {
        if (null == thread) {
            return;
        }
        thread.interrupt();
    }

    public static void chgName(String thName) {
        Thread.currentThread().setName(thName);
    }

    static {
        ThBgMode = true;
    }
}

