/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.fmq;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kr.floware.AtomicBool;
import kr.floware.Ftil;
import kr.floware.Thread8;
import kr.floware.concurrent.BoundQueue;
import kr.floware.concurrent.LockUtils;
import kr.floware.concurrent.Lockable;
import kr.floware.fmq.MQConfig;
import kr.floware.fmq.MQListener;
import kr.floware.fmq.MQMessage;
import kr.floware.fmq.MsgKind;
import kr.floware.fmq.ReqLock;
import kr.floware.logging.Logger;
import kr.floware.socket.Tcp4;
import kr.floware.utils.Assert;
import kr.floware.utils.MemoryBuffer;

public class MQClient {
    private static Logger logger = Logger.getLogger();
    private static final int MAX_SIZE = 0x1400000;
    private BoundQueue<Object> qEvent = new BoundQueue();
    private BoundQueue<Object> qSend = new BoundQueue();
    private MQConfig config = new MQConfig();
    private MQListener mqListener;
    private ReentrantLock reqWaitLock = new ReentrantLock();
    private Map<String, ReqLock> ddReqLock = new ConcurrentHashMap<String, ReqLock>(64);
    private Tcp4 socket = new Tcp4();
    private AtomicBool atomInit = new AtomicBool();
    private AtomicBool atomActivated = new AtomicBool();
    private Lockable lockHbit = new Lockable();

    private Tcp4 getSocket() {
        return this.socket;
    }

    public boolean isActivated() {
        return this.atomActivated.get();
    }

    private MQListener getMQListener() {
        return this.mqListener;
    }

    public void setMQListener(MQListener mqListener) {
        this.mqListener = mqListener;
    }

    public MQConfig getConfig() {
        return this.config;
    }

    public void setConfig(MQConfig config) {
        this.config = config;
    }

    public int getQueuedCount() {
        return this.qEvent.size();
    }

    public boolean isConnected() {
        return this.getSocket().isConnected();
    }

    public void init() {
        Assert.isTrue(this.getConfig().getMyName().length() > 0, "MyName not set", new Object[0]);
        Assert.notNull(this.getMQListener(), "MQListener not set", new Object[0]);
        logger.i("MQ {} Init", this.getConfig());
        if (this.atomInit.trySetTrue()) {
            this.qEvent.clear();
            Thread8.platform().name("MQQ@" + this.hashCode()).start(this::taskEvent);
            Thread8.platform().name("MQH@" + this.hashCode()).start(this::taskHbit);
            Thread8.platform().name("MQR@" + this.hashCode()).start(this::taskRead);
            Thread8.platform().name("MQW@" + this.hashCode()).start(this::taskSend);
        }
    }

    private void connectOnce() {
        this.getSocket().setIpAddress(this.getConfig().getNextIp());
        this.getSocket().setPort(this.getConfig().getPort());
        try {
            Socket sck = new Socket();
            sck.connect(new InetSocketAddress(this.getSocket().getIpAddress(), this.getConfig().getPort()), 30000);
            this.getSocket().defSckOpt(sck);
        }
        catch (IOException e) {
            logger.w("{}:{} {}", this.getSocket().getIpAddress(), this.getSocket().getPort(), e.getMessage());
            this.getSocket().close();
            LockUtils.quietWait(1000);
        }
        catch (Exception e) {
            logger.e(e);
            LockUtils.quietWait(100);
        }
        if (this.isConnected()) {
            this.getConfig().resetNextIp();
            this.getSocket().setTimeout(this.getConfig().getHbMillis() + 5000);
            MQMessage mqmsg = new MQMessage();
            mqmsg.setRcvMode(this.getConfig().getRcvMode());
            mqmsg.setFromName(this.getConfig().getMyName());
            this.sendSysMsg(MsgKind.LEARNING, mqmsg);
            this.qEvent.enqueue(new QoComm());
        }
    }

    public void close() {
        logger.i("MQ %s close called", this.getConfig());
        if (this.atomInit.trySetFalse()) {
            this.lockHbit.signal();
            this.getSocket().close();
            this.qSend.enqueue(new QoClose());
            this.qEvent.enqueue(new QoClose());
        }
    }

    public void send(MQMessage msg) {
        Assert.notNull(msg, "msg is null", new Object[0]);
        this.defaultNameSet(msg);
        this.qSend.enqueue(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MQMessage request(MQMessage req, int millis) {
        Assert.notNull(req, "req message is null", new Object[0]);
        Assert.areNotEqual((Object)MQConfig.RcvMode.Monitor, (Object)this.getConfig().getRcvMode(), "Monitor not support", new Object[0]);
        String guid = UUID.randomUUID().toString();
        try {
            Assert.isTrue(this.reqWaitLock.tryLock(60000L, TimeUnit.MILLISECONDS), "Lock acquire fail", new Object[0]);
            req.chgKind(MsgKind.REQUEST);
            this.defaultNameSet(req);
            req.setReqName(guid);
            ReqLock lock = ReqLock.newInstance(this.reqWaitLock);
            Condition condition = lock.getCondition();
            this.ddReqLock.put(guid, lock);
            MQMessage clone = (MQMessage)req.clone();
            this.send(req);
            boolean waked = condition.await(millis, TimeUnit.MILLISECONDS);
            if (!waked) {
                this.sendSysMsg(MsgKind.REMOVE_REQ, clone);
                this.qEvent.enqueue(new QoTimeout(req));
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            if (this.reqWaitLock.isLocked()) {
                this.reqWaitLock.unlock();
            }
        }
        return this.ddReqLock.remove(guid).getMessage();
    }

    public void reply(String reqName, MQMessage reply) {
        Assert.notNull(reply, "reply message is null", new Object[0]);
        Assert.areNotEqual((Object)MQConfig.RcvMode.Monitor, (Object)this.getConfig().getRcvMode(), "Monitor not support", new Object[0]);
        reply.chgKind(MsgKind.REPLY);
        reply.setReqName(reqName);
        this.send(reply);
    }

    public void reply(MQMessage recd, MQMessage reply) {
        Assert.notNull(recd, "recd message is null", new Object[0]);
        this.reply(recd.getReqName(), reply);
    }

    private void taskEvent() {
        while (this.atomInit.get()) {
            try {
                Object qo;
                Object obj = this.qEvent.dequeue();
                if (obj instanceof QoRecd) {
                    qo = (QoRecd)obj;
                    this.getMQListener().onMQRecd(((QoRecd)qo).msg);
                    continue;
                }
                if (obj instanceof QoSent) {
                    qo = (QoSent)obj;
                    switch (((QoSent)qo).msg.getKind()) {
                        case DATA: 
                        case REQUEST: 
                        case REPLY: {
                            this.getMQListener().onMQSent(((QoSent)qo).msg);
                            break;
                        }
                    }
                    continue;
                }
                if (obj instanceof QoComm) {
                    this.getMQListener().onMQContd(this.getConfig());
                    continue;
                }
                if (obj instanceof QoNotComm) {
                    this.getMQListener().onMQDiscontd(this.getConfig());
                    continue;
                }
                if (obj instanceof QoTimeout) {
                    qo = (QoTimeout)obj;
                    this.getMQListener().onMQTimeout(((QoTimeout)qo).msg);
                    continue;
                }
                if (obj instanceof QoSendFail) {
                    qo = (QoSendFail)obj;
                    switch (((QoSendFail)qo).msg.getKind()) {
                        case DATA: 
                        case REQUEST: 
                        case REPLY: {
                            this.getMQListener().onMQSendFail(((QoSendFail)qo).msg);
                            break;
                        }
                    }
                    continue;
                }
                if (!(obj instanceof QoClose)) continue;
            }
            catch (Exception e) {
                logger.e(e);
            }
        }
    }

    private void taskHbit() {
        while (this.atomInit.get()) {
            try {
                boolean awaked = this.lockHbit.await(this.getConfig().getHbMillis());
                if (awaked || !this.isConnected()) continue;
                this.sendSysMsg(MsgKind.HEART_BEAT);
            }
            catch (Exception e) {
                logger.e(e.getMessage());
            }
        }
    }

    private void taskRead() {
        while (this.atomInit.get()) {
            try {
                if (!this.isConnected()) {
                    this.connectOnce();
                    continue;
                }
                this.blockingRead();
            }
            catch (IOException e) {
                this.getSocket().close();
                this.qEvent.enqueue(new QoNotComm());
                if (!this.atomActivated.trySetFalse()) continue;
                this.getMQListener().onMQActiveChgd(this.isActivated());
            }
            catch (Exception e) {
                logger.e(e.getMessage());
            }
        }
    }

    private void taskSend() {
        while (this.atomInit.get()) {
            try {
                Object obj = this.qSend.dequeue();
                if (!(obj instanceof MQMessage)) continue;
                this.makeBufferAndWrite((MQMessage)obj);
            }
            catch (Exception e) {
                logger.e(e);
            }
        }
    }

    private void blockingRead() throws IOException {
        int length = this.getSocket().readBeInt();
        if (length < 392 || length > 0x1400000) {
            throw new IOException(Ftil.fff("MQClient invalid length %d", length));
        }
        byte[] hbs = this.getSocket().read(392);
        byte[] bbs = this.getSocket().read(length - 392);
        MQMessage mqmsg = new MQMessage();
        mqmsg.setHeader(hbs);
        if (mqmsg.getKind() == MsgKind.HEART_BEAT_REP) {
            return;
        }
        mqmsg.headerDecoding();
        switch (mqmsg.getKind()) {
            case COMM_STATE_TRUE: 
            case COMM_STATE_FALSE: {
                return;
            }
            case ACTIVE_STATE_TRUE: 
            case ACTIVE_STATE_FALSE: {
                if (mqmsg.getKind().isActiveTrue() ? this.atomActivated.trySetTrue() : this.atomActivated.trySetFalse()) {
                    this.getMQListener().onMQActiveChgd(this.isActivated());
                }
                return;
            }
        }
        mqmsg.setBody(bbs);
        mqmsg.jsonFromBodyArray();
        this.receiveOrReply(mqmsg);
    }

    private void defaultNameSet(MQMessage mqmsg) {
        if (mqmsg.getFromName().length() < 1) {
            mqmsg.setFromName(this.getConfig().getMyName());
        }
        switch (mqmsg.getKind()) {
            case DATA: 
            case REQUEST: {
                if (mqmsg.getToName().length() < 1) {
                    mqmsg.setToName(this.getConfig().getToName());
                }
                Assert.isTrue(mqmsg.getToName().length() > 0, "ToName not set MQConfig or MQMessage", new Object[0]);
                break;
            }
        }
    }

    private void makeBufferAndWrite(MQMessage mqmsg) {
        if (!this.isConnected()) {
            this.qEvent.enqueue(new QoSendFail(mqmsg));
            return;
        }
        mqmsg.headerEncoding();
        if (!mqmsg.getFields().isEmpty()) {
            mqmsg.jsonToBodyArray(this.getConfig().getAutoCompressMinSize());
        }
        try {
            int i = mqmsg.getLength();
            MemoryBuffer mb = new MemoryBuffer(4 + i);
            mb.appendBeInt(i);
            mb.append(mqmsg.getHeader());
            mb.append(mqmsg.getBody());
            this.getSocket().write(mb.toBytes());
            this.qEvent.enqueue(new QoSent(mqmsg));
        }
        catch (IOException e) {
            logger.e(e.getMessage());
        }
    }

    private void sendSysMsg(MsgKind system, MQMessage mqmsg) {
        mqmsg.getHeader()[0] = system.toByte();
        this.send(mqmsg);
    }

    private void sendSysMsg(MsgKind system) {
        MQMessage mqmsg = new MQMessage();
        this.sendSysMsg(system, mqmsg);
    }

    private void receiveOrReply(MQMessage recd) {
        String reqName;
        if (recd.getKind() == MsgKind.REPLY && this.ddReqLock.containsKey(reqName = recd.getReqName())) {
            ReqLock req = this.ddReqLock.get(reqName);
            req.setMessage(recd);
            Condition condition = req.getCondition();
            if (null != condition) {
                try {
                    Assert.isTrue(this.reqWaitLock.tryLock(60000L, TimeUnit.MILLISECONDS), "Lock Acquire fail", new Object[0]);
                }
                catch (InterruptedException e) {
                    logger.e(e);
                }
                condition.signal();
                this.reqWaitLock.unlock();
                return;
            }
        }
        this.qEvent.enqueue(new QoRecd(recd));
    }

    private class QoClose {
        private QoClose() {
        }
    }

    private class QoTimeout {
        private MQMessage msg;

        private QoTimeout(MQMessage msg) {
            this.msg = msg;
        }
    }

    private class QoRecd {
        private MQMessage msg;

        private QoRecd(MQMessage msg) {
            this.msg = msg;
        }
    }

    private class QoSendFail {
        private MQMessage msg;

        private QoSendFail(MQMessage msg) {
            this.msg = msg;
        }
    }

    private class QoSent {
        private MQMessage msg;

        private QoSent(MQMessage msg) {
            this.msg = msg;
        }
    }

    private class QoNotComm {
        private QoNotComm() {
        }
    }

    private class QoComm {
        private QoComm() {
        }
    }
}

