/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.fmq;

import kr.floware.Ftil;
import kr.floware.utils.Assert;

public class MQConfig {
    private static final String LOCAL_HOST = "127.0.0.1";
    private String ipAddress = "127.0.0.1";
    private int port = 7542;
    private RcvMode rcvMode = RcvMode.Default;
    private int heartbeat = 30;
    private String myName = "";
    private String toName = "";
    private int autoCompressMinSize = 2000;
    private int nextIp;
    private String contdSvrIp = "";

    String getNextIp() {
        String[] ss = this.getIpAddress().split(";");
        int mod = this.nextIp++ % ss.length;
        this.contdSvrIp = ss[mod];
        return this.contdSvrIp;
    }

    public String getContdIp() {
        return this.contdSvrIp;
    }

    void resetNextIp() {
        this.nextIp = 0;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String address) {
        String s = address.trim();
        if (s.equalsIgnoreCase("localhost")) {
            s = LOCAL_HOST;
        }
        this.ipAddress = s;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public RcvMode getRcvMode() {
        return this.rcvMode;
    }

    public void setRcvMode(RcvMode rcvMode) {
        this.rcvMode = rcvMode;
    }

    public String getMyName() {
        return this.myName;
    }

    public void setMyName(String myName) {
        Assert.notNull(myName, "MQConfig's myName is null", new Object[0]);
        String name = myName.trim();
        Assert.isTrue(name.length() < 65, "MyName Length < 65", new Object[0]);
        this.myName = name;
    }

    public String getToName() {
        return this.toName;
    }

    public void setToName(String toName) {
        Assert.notNull(toName, "MQConfig's ToName is null", new Object[0]);
        String name = toName.trim();
        Assert.isTrue(name.length() < 65, "ToName Length < 65", new Object[0]);
        this.toName = name;
    }

    public void setHeartbeat(int heartbeat) {
        if (heartbeat > 1 && heartbeat < 51) {
            this.heartbeat = heartbeat;
        }
    }

    int getHbMillis() {
        return this.heartbeat * 1000;
    }

    public void setAutoCompressMinSize(int autoCompressMinSize) {
        this.autoCompressMinSize = autoCompressMinSize;
    }

    public int getAutoCompressMinSize() {
        return this.autoCompressMinSize;
    }

    public String toString() {
        return Ftil.fff("%s->%s [%s/%s] (%s)", this.getMyName(), this.getToName(), this.getIpAddress(), this.getPort(), this.getContdIp());
    }

    public static enum RcvMode {
        Default(0),
        Queue(16),
        Balance(32),
        Monitor(48);

        private byte mode = 0;

        private RcvMode(byte mode) {
            this.mode = mode;
        }

        public byte toByte() {
            return this.mode;
        }

        public static RcvMode fromByte(byte b) {
            switch (b) {
                case 0: {
                    return Default;
                }
                case 16: {
                    return Queue;
                }
                case 32: {
                    return Balance;
                }
                case 48: {
                    return Monitor;
                }
            }
            return null;
        }
    }
}

