/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.fmq;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kr.floware.Ftil;
import kr.floware.fmq.MQConfig;
import kr.floware.fmq.MsgKind;
import kr.floware.fmq.Utils;
import kr.floware.utils.Assert;
import kr.floware.utils.JsonUtils;
import kr.floware.utils.ZipUtils;

public class MQMessage
implements Cloneable {
    static final int HEADER_SIZE = 392;
    private String fromName = "";
    private String toName = "";
    private String reqName = "";
    private boolean timeout;
    private byte[] header = new byte[392];
    private byte[] body = new byte[0];
    private Map<String, Object> fields = new HashMap<String, Object>(32);
    static final byte SPACE = 32;

    public boolean hasField(String fieldName) {
        return this.getFields().containsKey(fieldName);
    }

    public boolean isTimeout() {
        return this.timeout;
    }

    void setTimeout(boolean timeout) {
        this.timeout = timeout;
    }

    public void addField(String fieldName, Object v) {
        Assert.notNull(v, "addField value not null", new Object[0]);
        this.getFields().put(fieldName, v);
    }

    public void addField(Object v) {
        this.addField("DATA", v);
    }

    public Map<String, Object> getFields() {
        return this.fields;
    }

    public Object getField(String fieldName) {
        Assert.isTrue(this.getFields().containsKey(fieldName), Ftil.fff("%s field not exist", fieldName), new Object[0]);
        return this.getFields().get(fieldName);
    }

    public String getFieldV(String fieldName) {
        return this.getField(fieldName).toString();
    }

    public int getFieldIntV(String fieldName) {
        return Ftil.toInt(this.getField(fieldName).toString());
    }

    void jsonToBodyArray(int autoCompressMinSize) {
        this.setBody(Utils.encode(JsonUtils.toJsonString(this.getFields()), "utf-8"));
        if (this.isCompress() || this.getBody().length >= autoCompressMinSize) {
            this.setCompress(true);
            this.setBody(ZipUtils.gzip(this.getBody()));
        }
    }

    void jsonFromBodyArray() {
        if (this.isCompress()) {
            this.setBody(ZipUtils.ungzip(this.getBody()));
        }
        String js = Utils.decode(this.getBody(), "utf-8");
        this.fields = JsonUtils.fromJsonString(js);
    }

    int getLength() {
        return 392 + this.getBody().length;
    }

    byte[] getBody() {
        return this.body;
    }

    void setBody(byte[] bbs) {
        this.body = bbs;
    }

    public String getFromName() {
        return this.fromName;
    }

    public void setFromName(String fromName) {
        Assert.notNull(fromName, "MQMessage's FromName is null", new Object[0]);
        String name = fromName.trim();
        Assert.isTrue(name.length() < 65, "FromName Length<65 '%s'", name);
        this.fromName = name;
    }

    public String getToName() {
        return this.toName;
    }

    public void setToName(String toName) {
        Assert.notNull(toName, "MQMessage's ToName is null", new Object[0]);
        String name = toName.trim();
        Assert.isTrue(name.length() < 65, "ToName Length<65 '%s'", name);
        this.toName = name;
    }

    public String getReqName() {
        return this.reqName;
    }

    void setReqName(String reqName) {
        this.reqName = reqName.trim();
    }

    byte[] getHeader() {
        return this.header;
    }

    void setHeader(byte[] hbs) {
        this.header = hbs;
    }

    public boolean isRequest() {
        return this.getKind() == MsgKind.REQUEST;
    }

    public String toString() {
        return Ftil.fff("[%d] %s>%s '%s' %s", this.getLength(), this.getFromName(), this.getToName(), this.getReqName(), this.isRequest() ? " R" : "");
    }

    public String getContentString() {
        return Ftil.fff("[%s->%s] (%s)", this.getFromName(), this.getToName(), this.getFields());
    }

    public void setCompress(boolean compress) {
        Ftil.bitMaskSet(this.header, 3, 0, compress);
    }

    boolean isCompress() {
        return Ftil.bitMaskIsSet(this.header[3], 0);
    }

    void headerEncoding() {
        Arrays.fill(this.header, 8, 392, (byte)32);
        byte[] frombs = Utils.encode(this.getFromName(), "utf-8");
        byte[] tobs = Utils.encode(this.getToName(), "utf-8");
        byte[] reqbs = Utils.encode(this.getReqName(), "utf-8");
        Assert.isTrue(frombs.length < 129, "FromName unicode length error %d '%s'", frombs.length, this.getFromName());
        Assert.isTrue(tobs.length < 129, "ToName unicode length error %d '%s'", tobs.length, this.getToName());
        Assert.isTrue(reqbs.length < 129, "ReqName unicode length error %d  '%s'", reqbs.length, this.getReqName());
        System.arraycopy(frombs, 0, this.header, 8, frombs.length);
        System.arraycopy(tobs, 0, this.header, 136, tobs.length);
        System.arraycopy(reqbs, 0, this.header, 264, reqbs.length);
    }

    void headerDecoding() {
        byte[] frombs = new byte[128];
        byte[] tobs = new byte[128];
        byte[] reqbs = new byte[128];
        Arrays.fill(frombs, (byte)32);
        Arrays.fill(tobs, (byte)32);
        Arrays.fill(reqbs, (byte)32);
        System.arraycopy(this.header, 8, frombs, 0, 128);
        System.arraycopy(this.header, 136, tobs, 0, 128);
        System.arraycopy(this.header, 264, reqbs, 0, 128);
        this.setFromName(Utils.decode(frombs, "utf-8"));
        this.setToName(Utils.decode(tobs, "utf-8"));
        this.setReqName(Utils.decode(reqbs, "utf-8"));
    }

    public Object clone() {
        try {
            MQMessage clone = (MQMessage)super.clone();
            clone.header = Utils.arraycopy(this.header);
            clone.setBody(Utils.arraycopy(this.body));
            clone.fields = this.getFields().entrySet().stream().collect(Collectors.toMap(x -> (String)x.getKey(), x -> x.getValue()));
            return clone;
        }
        catch (CloneNotSupportedException e) {
            Assert.fail(e);
            return null;
        }
    }

    MsgKind getKind() {
        return MsgKind.fromByte(this.getHeader()[0]);
    }

    void chgKind(MsgKind sys) {
        this.getHeader()[0] = sys.toByte();
    }

    void setRcvMode(MQConfig.RcvMode rcvMode) {
        this.getHeader()[1] = rcvMode.toByte();
    }
}

