/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.hsms;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kr.floware.Thread8;
import kr.floware.concurrent.BoundQueue;
import kr.floware.concurrent.LockUtils;
import kr.floware.concurrent.Lockable;
import kr.floware.hsms.HsmsConfig;
import kr.floware.hsms.HsmsListener;
import kr.floware.hsms.HsmsMsgLib;
import kr.floware.hsms.HsmsQo;
import kr.floware.hsms.HsmsQoComm;
import kr.floware.hsms.HsmsQoLog;
import kr.floware.hsms.HsmsQoNotComm;
import kr.floware.hsms.HsmsQoRecd;
import kr.floware.hsms.HsmsQoRecdUnk;
import kr.floware.hsms.HsmsQoSent;
import kr.floware.hsms.HsmsQoSleep;
import kr.floware.hsms.HsmsQoT3;
import kr.floware.hsms.ReqLock;
import kr.floware.hsms.format.SFMessage;
import kr.floware.logging.Logger;
import kr.floware.quartz.TimerListener;
import kr.floware.quartz.TimerTemplate;
import kr.floware.socket.TcpConnector;
import kr.floware.socket.TcpLogListener;
import kr.floware.socket.TcpUtils;
import kr.floware.utils.Assert;
import kr.floware.utils.LamUtils;

public class HsmsManager {
    private static Logger logger = Logger.getLogger();
    private HsmsListener listener;
    private BoundQueue<HsmsQo> qEvent = new BoundQueue();
    private BoundQueue<SFMessage> qSend = new BoundQueue();
    boolean inited;
    ThreadGroup thgroup = new ThreadGroup("hsms");
    Lockable lockLQ = new Lockable();
    private HsmsMsgLib hsmsMsgLib = new HsmsMsgLib();
    private TimerTemplate<Long, SFMessage> quz1 = new TimerTemplate("HT3@" + this.hashCode());
    private HsmsConfig config = new HsmsConfig();
    private static final long MAX_SYSTEMBYTE = 0x40000001L;
    AtomicLong sysbyte = new AtomicLong(1L);
    private long ctrlSysbyte = 0x40000001L;
    private volatile TcpConnector h = new TcpConnector();
    TcpLogListener hLog = new TcpLogListener(){

        @Override
        public void onLog(String s) {
            HsmsManager.this.qEvent.enqueue(new HsmsQoLog(s));
        }
    };
    private boolean active = true;
    private ReentrantLock reqWaitLock = new ReentrantLock();
    private Map<Long, ReqLock> mapReQ = new ConcurrentHashMap<Long, ReqLock>(64);
    Map<Long, Object> kvCorr = LamUtils.newMap(256);

    public HsmsManager() {
        this.quz1.addTimerListeners(new TimerListener<Long, SFMessage>(){

            @Override
            public void onTimeout(Long id, SFMessage attachment) {
                HsmsManager.this.qEvent.enqueue(new HsmsQoT3(attachment));
                HsmsManager.this.kvCorr.remove(attachment.getSystembyte());
            }
        });
    }

    private HsmsMsgLib getMsgLib() {
        return this.hsmsMsgLib;
    }

    public HsmsConfig getConfig() {
        return this.config;
    }

    public void setConfig(HsmsConfig config) {
        this.config = config;
    }

    private SFMessage chgMsgID(Object obj) {
        HsmsQo hq = (HsmsQo)obj;
        SFMessage msg = (SFMessage)hq.getArg1();
        msg.setId(this.getConfig().getID());
        return msg;
    }

    private HsmsListener getListener() {
        return this.listener;
    }

    public void setHsmsListener(HsmsListener listener) {
        this.listener = listener;
    }

    public void readMsgLibrary(String path) {
        this.getMsgLib().clearMsgs();
        this.getMsgLib().readDefinedMsg(path);
        logger.i("ID:%s path:%s readMsgLibrary", this.getConfig().getID(), path);
    }

    public synchronized void connect() {
        this.connect(true);
    }

    public synchronized void connect(boolean active) {
        this.active = active;
        Assert.isFalse(this.inited, "%s already running", this.getConfig().getID());
        Assert.notNull(this.getListener(), "%s HsmsListener not set", this.getConfig().getID());
        this.inited = true;
        Thread8.platform().name("HQ@" + this.getConfig().getID()).start(this::task_pump);
        Thread8.platform().group(this.thgroup).name("HW@" + this.getConfig().getID()).start(this::task_send);
        Thread8.platform().group(this.thgroup).name("HR@" + this.getConfig().getID()).start(this::task_read);
        Thread8.platform().group(this.thgroup).name("HL@" + this.getConfig().getID()).start(this::task_link);
    }

    public boolean isConnected() {
        return this.h.isConnected();
    }

    public synchronized void disconnect() {
        this.inited = false;
        this._queueLog("DISCONNECT REQUEST " + this.getConfig().getID());
        this.h.close();
        this.thgroup.interrupt();
        this.qEvent.enqueue(new HsmsQoSleep());
        this.quz1.dispose();
        this.getListener().onHsmsDiscontd(this.getConfig());
    }

    public SFMessage getMessage(String name) {
        return this.getMsgLib().getMsg(name);
    }

    public void reconnect() {
        TcpUtils.quietClose(this.h.getSocket());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SFMessage reqReply(SFMessage msg, int millis) {
        try {
            SFMessage rsp;
            Assert.isFalse(msg.isSecondary(), "reqReply only primary %s", msg.logHeader());
            Assert.isTrue(msg.isWbit(), "reqReply need wbit %s", msg.logHeader());
            Assert.isTrue(this.reqWaitLock.tryLock(60000L, TimeUnit.MILLISECONDS), "Lock acquire fail", new Object[0]);
            ReqLock req = new ReqLock(this.reqWaitLock);
            Condition condition = req.getCondition();
            this.send(msg);
            this.mapReQ.put(msg.getSystembyte(), req);
            boolean waked = condition.await(millis, TimeUnit.MILLISECONDS);
            SFMessage sFMessage = rsp = waked ? this.mapReQ.get(msg.getSystembyte()).getMsg() : null;
            if (waked) {
                rsp.setId(this.getConfig().getID());
            }
            SFMessage sFMessage2 = rsp;
            return sFMessage2;
        }
        catch (InterruptedException e) {
            logger.w(e.getMessage());
        }
        finally {
            if (this.reqWaitLock.isLocked()) {
                this.reqWaitLock.unlock();
            }
            this.mapReQ.remove(msg.getSystembyte());
        }
        return null;
    }

    public void send(SFMessage msg) {
        if (msg.isControlMessage()) {
            if (msg.getStype() == 1 || msg.getStype() == 5) {
                msg.setSystembyte(this.ctrlSysbyte++);
            }
        } else {
            if (msg.getDeviceId() < 1) {
                msg.setDeviceId(this.config.getDeviceID());
            }
            if (!msg.isSecondary() && msg.getSystembyte() < 1L) {
                msg.setSystembyte(this.sysbyte.getAndIncrement());
            }
            if (msg.isWbit() && !msg.isSecondary() && msg.getCorrelation() != null) {
                this.kvCorr.put(msg.getSystembyte(), msg.getCorrelation());
            }
        }
        this.qSend.enqueue(msg);
    }

    private void _onMessageRecd(SFMessage recd) {
        boolean syncRsp;
        this.lockLQ.signal();
        if (recd.isControlMessage()) {
            this._queueLog(recd.logFormat());
            if (recd.isHsmsSelectReqMessage()) {
                SFMessage rep = (SFMessage)recd.clone();
                rep.setStype(2);
                this.send(rep);
                this.qEvent.enqueue(new HsmsQoComm());
            } else if (recd.isHsmsSelectRspMessage()) {
                this.qEvent.enqueue(new HsmsQoComm());
            } else if (recd.isHsmsLinkReqMessage()) {
                SFMessage rep = (SFMessage)recd.clone();
                rep.setStype(6);
                this.send(rep);
            } else if (recd.isHsmsLinkRspMessage()) {
                this._queueLog(recd.logFormat());
            } else {
                logger.w(recd.logFormat());
            }
            return;
        }
        if (recd.isSecondary() && this.kvCorr.containsKey(recd.getSystembyte())) {
            recd.setCorrelation(this.kvCorr.remove(recd.getSystembyte()));
        }
        this.quz1.stop(recd.getSystembyte());
        recd.decoding();
        List<SFMessage> compList = null;
        boolean well = this.getMsgLib().findWellKnownMsg(recd, compList);
        recd.setCompList(compList);
        boolean bl = syncRsp = recd.isSecondary() && this.mapReQ.containsKey(recd.getSystembyte());
        if (syncRsp) {
            ReqLock req = this.mapReQ.get(recd.getSystembyte());
            Assert.notNull(req, "req %s already or confused subject name", recd.logHeader());
            req.setMsg(recd);
            Condition cond = req.getCondition();
            if (null == cond) {
                logger.w("Unknown condition %s", recd.logHeader());
                return;
            }
            try {
                Assert.isTrue(this.reqWaitLock.tryLock(60000L, TimeUnit.MILLISECONDS), "Lock Acquire fail", new Object[0]);
            }
            catch (InterruptedException e) {
                logger.e(e);
            }
            cond.signal();
            if (this.reqWaitLock.isLocked()) {
                this.reqWaitLock.unlock();
            }
            return;
        }
        if (recd.getDeviceId() != this.getConfig().getDeviceID()) {
            recd.setUnkCode(1);
            String log = String.format("Mismatch DeviceID %s", recd.logFormat());
            this._queueLog(log);
            logger.w(log);
            this.qEvent.enqueue(new HsmsQoRecdUnk(recd));
        } else if (well || recd.isAbortMessage()) {
            this.qEvent.enqueue(new HsmsQoRecd(recd));
        } else {
            this.qEvent.enqueue(new HsmsQoRecdUnk(recd));
        }
        this.autoRepMsg(recd);
    }

    private void autoRepMsg(SFMessage recd) {
        if (recd.isSecondary() || !recd.isWbit()) {
            return;
        }
        if (!this.getMsgLib().hasAutoReply(recd)) {
            return;
        }
        this.send(this.getMsgLib().getAutoReplyCloneMsg(recd));
    }

    private void _onTcpContd() {
        if (!this.active) {
            return;
        }
        this.h.setTimeout(this.getConfig().getSckTimeout());
        SFMessage msg = new SFMessage();
        msg.setStype(1);
        this.send(msg);
    }

    private void _queueLog(String log) {
        this.qEvent.enqueue(new HsmsQoLog(log));
    }

    private void _queueSent(SFMessage msg) {
        this.qEvent.enqueue(new HsmsQoSent(msg));
    }

    private void _onTcpDiscontd(IOException e) {
        this.qEvent.enqueue(new HsmsQoNotComm());
        this.quz1.stopAll();
        this.mapReQ.clear();
        this.sysbyte.set(1L);
        this.kvCorr.clear();
    }

    private void task_pump() {
        while (true) {
            try {
                while (true) {
                    SFMessage msg;
                    HsmsQo obj;
                    if ((obj = this.qEvent.dequeue()) instanceof HsmsQoLog) {
                        HsmsQoLog qo = (HsmsQoLog)obj;
                        this.getListener().onHsmsLog(this.getConfig(), (String)qo.getArg1());
                        continue;
                    }
                    if (obj instanceof HsmsQoRecd) {
                        msg = this.chgMsgID(obj);
                        this.getListener().onHsmsRecd(msg);
                        continue;
                    }
                    if (obj instanceof HsmsQoRecdUnk) {
                        msg = this.chgMsgID(obj);
                        this.getListener().onHsmsRecdUnk(msg);
                        continue;
                    }
                    if (obj instanceof HsmsQoComm) {
                        this.getListener().onHsmsContd(this.getConfig());
                        continue;
                    }
                    if (obj instanceof HsmsQoNotComm) {
                        this.getListener().onHsmsDiscontd(this.getConfig());
                        continue;
                    }
                    if (obj instanceof HsmsQoSent) {
                        msg = this.chgMsgID(obj);
                        this.getListener().onHsmsSent(msg);
                        continue;
                    }
                    if (obj instanceof HsmsQoT3) {
                        msg = this.chgMsgID(obj);
                        this.getListener().onHsmsTimeout3(msg);
                        continue;
                    }
                    if (obj instanceof HsmsQoSleep) break;
                }
            }
            catch (Exception e) {
                logger.e(e);
                continue;
            }
            break;
        }
    }

    private void task_read() {
        while (this.inited) {
            try {
                if (!this.isConnected()) {
                    this.tcpConnecting();
                    continue;
                }
                int hsmsLength = this.h.readBeInt();
                if (hsmsLength < 10 || hsmsLength > 0x2000000) {
                    throw new IOException(String.format("Abnormal hsms length %d", hsmsLength));
                }
                SFMessage m = this.readStream(hsmsLength);
                if (m.isSeparateReqMessage()) {
                    this._queueLog(m.logFormat());
                    throw new IOException("Separate request message");
                }
                this._onMessageRecd(m);
            }
            catch (IOException e) {
                logger.w(e);
                this._onTcpDiscontd(e);
                this.h.close();
                LockUtils.quietWait(this.getConfig().getT5() * 1000);
            }
            catch (Exception e) {
                logger.e(e);
            }
        }
    }

    private void task_send() {
        while (this.inited) {
            try {
                SFMessage msg = this.qSend.dequeueThrow();
                if (!this.h.isConnected()) {
                    logger.w("%s not connected, send fail %s", this.getConfig(), msg.logFormat());
                    continue;
                }
                msg.setReceive(false);
                if (msg.isControlMessage()) {
                    this._queueLog(msg.logFormat());
                } else {
                    msg.encode();
                    this.startT3(msg);
                    this._queueSent(msg);
                }
                byte[] bs = msg.makeHsmsBytesAll();
                this.h.write(bs);
            }
            catch (IOException e) {
                logger.e(e);
            }
            catch (InterruptedException e) {
                break;
            }
            catch (Exception e) {
                logger.e(e);
            }
        }
    }

    private void task_link() {
        while (this.inited) {
            try {
                boolean awaked = this.lockLQ.await(this.getConfig().getLinktest() * 1000);
                if (awaked || !this.isConnected()) continue;
                SFMessage msg = new SFMessage();
                msg.setStype(5);
                this.send(msg);
            }
            catch (InterruptedException e) {
                break;
            }
            catch (Exception e) {
                logger.e(e);
            }
        }
    }

    private void tcpConnecting() {
        this.h.setIpAddress(this.getConfig().getIpAddress());
        this.h.setPort(this.getConfig().getPort());
        if (this.active) {
            this.h.tryConnect(this.hLog);
        } else {
            this.h.tryListen(this.hLog);
        }
        if (this.h.isConnected()) {
            this._onTcpContd();
            return;
        }
        LockUtils.quietWait(this.getConfig().getT5() * 1000);
    }

    private SFMessage readStream(int len) throws IOException {
        byte[] bs = this.h.read(len);
        SFMessage msg = new SFMessage();
        msg.setReceive(true);
        return msg.allocateHsms(msg, bs);
    }

    private void startT3(SFMessage msg) {
        if (!msg.isControlMessage()) {
            if (msg.isSecondary() || !msg.isWbit()) {
                return;
            }
            this.quz1.startOnce(this.getConfig().getT3() * 1000, msg.getSystembyte(), msg);
        }
    }
}

