/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.hsms;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import kr.floware.hsms.format.SFMessage;
import kr.floware.logging.Logger;
import kr.floware.utils.Assert;
import kr.floware.utils.FileUtils;
import kr.floware.utils.JdomUtils;
import org.jdom.Document;
import org.jdom.Element;

public class HsmsMsgLib {
    private static Logger logger = Logger.getLogger();
    private Map<String, SFMessage> msgs = new ConcurrentHashMap<String, SFMessage>();
    private Map<String, SFMessage> autoReps = new ConcurrentHashMap<String, SFMessage>();
    private Map<String, CopyOnWriteArrayList<SFMessage>> sxfies = new ConcurrentHashMap<String, CopyOnWriteArrayList<SFMessage>>();

    protected void clearMsgs() {
        this.msgs.clear();
        this.autoReps.clear();
        this.sxfies.clear();
    }

    protected Map<String, SFMessage> getMsgs() {
        return this.msgs;
    }

    protected SFMessage getAutoReplyCloneMsg(SFMessage recd) {
        String str = recd.getSxfyRsp();
        SFMessage msg = this.getAutoReplies().get(str);
        SFMessage clone = (SFMessage)msg.clone();
        clone.setDeviceId(recd.getDeviceId());
        clone.setId(recd.getId());
        clone.setSystembyte(recd.getSystembyte());
        return clone;
    }

    boolean hasAutoReply(SFMessage msg) {
        if (msg.isSecondary()) {
            return false;
        }
        return this.getAutoReplies().containsKey(msg.getSxfyRsp());
    }

    protected Map<String, SFMessage> getAutoReplies() {
        return this.autoReps;
    }

    protected boolean findWellKnownMsg(SFMessage recd, List<SFMessage> compList) {
        compList = new CopyOnWriteArrayList<SFMessage>();
        if (!this.sxfies.containsKey(recd.getSxFx())) {
            recd.setUnkCode(5);
            logger.w("Unknown stream/function %s", recd.logFormat());
            return false;
        }
        List ll = this.sxfies.get(recd.getSxFx());
        for (SFMessage iter : ll) {
            SFMessage clone = (SFMessage)iter.clone();
            if (clone.isWellKnown(recd)) {
                clone.copyNames(recd);
                recd.setUnkCode(0);
                return true;
            }
            compList.add(clone);
        }
        if (recd.getUnkCode() == 0) {
            recd.setUnkCode(7);
        }
        return false;
    }

    protected void addDefinedMsg(SFMessage msg) {
        this.msgs.put(msg.getName(), msg);
        if (msg.isAutoreply()) {
            String sxFy = msg.getSxFx();
            if (!this.getAutoReplies().containsKey(sxFy)) {
                this.getAutoReplies().put(msg.getSxFx(), msg);
            }
        }
        if (!this.sxfies.containsKey(msg.getSxFx())) {
            this.sxfies.put(msg.getSxFx(), new CopyOnWriteArrayList());
        }
        this.sxfies.get(msg.getSxFx()).add(msg);
    }

    public void readDefinedMsg(String path) {
        Assert.notNull(path, "*.sfm path is null", new Object[0]);
        Assert.isTrue(FileUtils.isExist(path), "%s not exist", path);
        try {
            Document doc = JdomUtils.loadFile(path);
            Element root = doc.getRootElement();
            for (int i = 0; i < root.getChildren().size(); ++i) {
                Element el = (Element)root.getChildren().get(i);
                SFMessage msg = new SFMessage();
                msg.fromLibrary(el);
                this.addDefinedMsg(msg);
            }
        }
        catch (Exception e) {
            Assert.fail(e);
        }
    }

    public SFMessage getMsg(String msgName) {
        Assert.isFalse(this.getMsgs().isEmpty(), "SFM not loaded", new Object[0]);
        Assert.isTrue(this.getMsgs().containsKey(msgName), "%s not exist", msgName);
        return (SFMessage)this.getMsgs().get(msgName).clone();
    }
}

