/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.hsms.format;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kr.floware.Ftil;
import kr.floware.hsms.format.BytesConverter;
import kr.floware.hsms.format.Format;
import kr.floware.hsms.format.Formatter;
import kr.floware.hsms.format.ListFormat;
import kr.floware.hsms.format.ObjectConverter;
import kr.floware.hsms.format.SFMessage;
import kr.floware.utils.Assert;
import kr.floware.utils.ConstUtils;
import kr.floware.utils.MemoryBuffer;
import kr.floware.utils.StreamUtils;
import org.jdom.Element;

public abstract class AbstractFormat
implements Format {
    private static final String SPACE19 = "                   ";
    protected static final String XXXXX_DIFF_FORMAT = "xxxxx Different Format";
    protected static final String XXXXX_STRICT_VALUE_MISMATCH = "xxxxx StrictValue mismatch";
    protected static final String SPACE = " ";
    protected Map<String, String> aliasValues = new HashMap<String, String>();
    private String name = "";
    private String aliasName;
    private int length;
    private String originValue = "";
    private int level;
    private boolean fixedLength = true;
    private boolean strictValue = false;
    private Format parent;
    protected static String LENGTH = "length";
    protected static String NAME = "name";
    protected static String FIXED = "fixed";
    protected static String VALUES = "values";
    protected static String ALIASVALUE = "aliasvalues";
    protected static String STRICT_VALUE = "strictvalue";
    private String comment = "";
    protected String attachIndex = "";
    private SFMessage message;

    public abstract int valueCopy(byte[] var1, int var2);

    protected int multiple() {
        return 1;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public Format idx(int ... idx) {
        return this.getByIndex(idx);
    }

    public boolean isStrictValue() {
        return this.strictValue;
    }

    public void setStrictValue(boolean strictValue) {
        this.strictValue = strictValue;
    }

    @Override
    public void setAttachIndex(String attachIndex) {
        this.attachIndex = attachIndex;
    }

    @Override
    public String getAttachIndex() {
        return this.attachIndex;
    }

    @Override
    public String getAliasName() {
        return this.aliasName;
    }

    @Override
    public void setAliasName(String aliasName) {
        this.aliasName = aliasName;
    }

    @Override
    public SFMessage getMessage() {
        return this.message;
    }

    @Override
    public void setFixedLength(boolean fixedLength) {
        this.fixedLength = fixedLength;
    }

    @Override
    public boolean isFixedLength() {
        return this.fixedLength;
    }

    @Override
    public void duplicateChildren(int count) {
        Assert.fail("Need implement duplicateChildren", new Object[0]);
    }

    @Override
    public void setMessage(SFMessage message) {
        this.message = message;
    }

    @Override
    public Format copyNames(Format require) {
        require.setName(this.getName());
        require.setAttachIndex(this.getAttachIndex());
        require.getMessage().addName(require);
        ((AbstractFormat)require).aliasValues = this.aliasValues;
        return require;
    }

    @Override
    public boolean hasChildren() {
        return this.getChildren().size() > 0;
    }

    @Override
    public boolean hasName() {
        if (this.getName() == null) {
            return false;
        }
        return this.getName().trim().length() >= 1;
    }

    @Override
    public boolean isListFormat() {
        return false;
    }

    @Override
    public Format getByIndex(int index) {
        return this.getByIndex(new int[]{index});
    }

    @Override
    public Format getByIndex(int ... indexes) {
        try {
            Format format = this;
            for (int index : indexes) {
                if (!format.isListFormat()) {
                    Format clone = (Format)format.clone();
                    clone.setValue(clone.getValue().split(SPACE)[index]);
                    return clone;
                }
                format = format.getChild(index);
            }
            return format;
        }
        catch (Exception e) {
            this.setComment("getByIndex error " + e);
            return null;
        }
    }

    @Override
    public Format getFirstList() {
        for (Format f : this.getChildren()) {
            if (!(f instanceof ListFormat)) continue;
            return f;
        }
        return null;
    }

    @Override
    public Format getFirstChild() {
        return this.getChildren().size() < 1 ? null : this.getChildren().get(0);
    }

    @Override
    public Format getChild(int index) {
        return this.getChildren().get(index);
    }

    protected int getLowerLoopCountBetweenLengthAndSplits(String[] splits) {
        if (splits.length == 1 && splits[0].equals("")) {
            return 0;
        }
        return this.getLength() > splits.length ? splits.length : this.getLength();
    }

    @Override
    public Format add(Format format) {
        format.setMessage(this.getMessage());
        if (this.getMessage() != null && format.hasName()) {
            this.getMessage().addName(format);
        }
        return format;
    }

    @Override
    public Format add(int type, int length, String name, int value) {
        return this.add(type, length, name, String.valueOf(value));
    }

    @Override
    public Format add(int type, int length, String name, String value) {
        Format format = Formatter.newInstance(type);
        format.setLength(length);
        format.setName(name);
        format.setValue(value);
        return this.add(format);
    }

    @Override
    public Object clone() {
        try {
            Format clone = (Format)super.clone();
            return this.detach(clone);
        }
        catch (CloneNotSupportedException e) {
            this.setComment(e.getMessage());
            return null;
        }
    }

    protected Format detach(Format format) {
        format.setParent(null);
        return format;
    }

    @Override
    public void replace(Format origin, Format newA) {
        newA.setParent(origin.getParent());
        int index = this.getParent().getChildren().indexOf(origin);
        this.getParent().getChildren().remove(index);
        this.getParent().getChildren().add(index, newA);
    }

    protected String elementName(boolean attachIndex) {
        if (null != this.getAliasName()) {
            return this.getAliasName();
        }
        if (null == this.getName()) {
            return this.getLogType();
        }
        if (this.getName().trim().equals("")) {
            return this.getLogType();
        }
        return attachIndex ? this.getFullName() : this.getName();
    }

    private int getLength4Type(int length, byte[] bs, int pos) {
        byte[] temp = new byte[4];
        switch (length) {
            case 1: {
                return bs[pos] & 0xFF;
            }
            case 2: {
                System.arraycopy(bs, pos, temp, 2, 2);
                return BytesConverter.byte2Int(temp);
            }
        }
        System.arraycopy(bs, pos, temp, 1, 3);
        return BytesConverter.byte2Int(temp);
    }

    private int reductionDecodeLength(int length) {
        switch (this.getType()) {
            case 104: 
            case 168: {
                return length / 2;
            }
            case 112: 
            case 144: 
            case 176: {
                return length / 4;
            }
            case 96: 
            case 128: 
            case 160: {
                return length / 8;
            }
        }
        return length;
    }

    int decoding(byte[] bs, int pos) {
        int type = bs[pos] & 0xFF;
        if (type == this.getType() + 1) {
            this.setLength(this.reductionDecodeLength(this.getLength4Type(1, bs, ++pos)));
            ++pos;
        } else if (type == this.getType() + 2) {
            this.setLength(this.reductionDecodeLength(this.getLength4Type(2, bs, ++pos)));
            pos += 2;
        } else {
            this.setLength(this.reductionDecodeLength(this.getLength4Type(3, bs, ++pos)));
            pos += 3;
        }
        pos = this.valueCopy(bs, pos);
        return pos;
    }

    @Override
    public List<Format> getChildren() {
        return new ArrayList<Format>();
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public void setLength(int length) {
        this.length = length;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getValue() {
        return this.getAliasValue();
    }

    @Override
    public String getOriginValue() {
        return this.originValue;
    }

    @Override
    public String getTrimValue() {
        return this.getAliasValue().trim();
    }

    protected boolean hasAlias() {
        return this.aliasValues.size() > 0;
    }

    protected String getAliasValue() {
        boolean contains;
        if (!this.hasAlias()) {
            this.getOriginValue();
        }
        return (contains = this.aliasValues.containsKey(this.originValue)) ? this.aliasValues.get(this.originValue) : this.originValue;
    }

    @Override
    public int getIntValue() {
        Assert.isTrue(this.getLength() > 0, "Length is 0 --> intValue error", new Object[0]);
        return Integer.parseInt(this.getAliasValue());
    }

    @Override
    public void setValue(String value) {
        if (value == null) {
            value = this.isAsciiFormat() ? "" : "0";
        }
        this.setOriginValue(value);
    }

    private void setOriginValue(String originValue) {
        this.originValue = originValue;
    }

    @Override
    public void setIntValue(int value) {
        this.originValue = String.valueOf(value);
    }

    public abstract String getLogType();

    public String treeString() {
        String name = this.getFullName() == null || this.getFullName().equals("") ? "" : this.getFullName() + SPACE;
        String orgV = this.getOriginValue();
        String fixed = this.isFixedLength() ? "" : "V";
        String aliasV = this.aliasValues.size() > 0 ? Ftil.fff(" [*%s]", this.getAliasValue()) : "";
        return Ftil.fff("%s %s%s %s'%s'%s", this.getLogType(), this.getLength(), fixed, name, orgV, aliasV);
    }

    protected String tab(int level) {
        String temp = SPACE19;
        for (int i = 0; i < level; ++i) {
            temp = temp + "    ";
        }
        return temp;
    }

    @Override
    public String logFormat() {
        return Ftil.fff("%s<%s> %s%s", this.tab(this.getLevel()), this.treeString(), this.getComment(), ConstUtils.NEWLINE);
    }

    public int getLevel() {
        return this.level;
    }

    @Override
    public void setIndex(int level) {
        this.level = level;
    }

    @Override
    public Format fromLibrary(Element element) {
        try {
            this.setName(element.getAttribute(NAME).getValue());
            this.setValue(null == element.getText() ? "" : element.getText());
            this.setLength(element.getAttribute(LENGTH).getIntValue());
            this.setFixedLength(element.getAttribute(FIXED).getBooleanValue());
            this.setStrictValue(element.getAttribute(STRICT_VALUE).getBooleanValue());
            this.setAliasValues(element);
            return this;
        }
        catch (Exception e) {
            this.setComment(e.toString());
            return null;
        }
    }

    void setAliasValues(Element element) {
        if (null == element.getAttribute(VALUES)) {
            return;
        }
        String values = element.getAttribute(VALUES).getValue();
        String aliases = element.getAttribute(ALIASVALUE).getValue();
        String[] keys = values.split(",");
        String[] vs = aliases.split(",");
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i].trim().length() < 1) continue;
            this.aliasValues.put(keys[i], vs[i]);
        }
    }

    @Override
    public boolean isAsciiFormat() {
        return false;
    }

    @Override
    public Format getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Format parent) {
        this.parent = parent;
    }

    protected Format clone2(int attach) {
        try {
            Format clone = (Format)this.clone();
            if (!clone.getName().trim().equals("")) {
                clone.setName(this.getName());
                String str = this.getMessage().isLongIdx() ? "_" + attach : String.valueOf(attach);
                clone.setAttachIndex(this.getAttachIndex() + str);
            }
            clone.setMessage(this.getMessage());
            return this.detach(clone);
        }
        catch (Exception e) {
            this.setComment(e.getMessage());
            return null;
        }
    }

    @Override
    public String getFullName() {
        return this.getName() + this.getAttachIndex();
    }

    @Override
    public boolean isWellKnown(Format checkIt) {
        boolean bl;
        if (this.getType() != checkIt.getType()) {
            this.setComment(XXXXX_DIFF_FORMAT);
            if (null != this.getMessage()) {
                this.getMessage().setComment(XXXXX_DIFF_FORMAT);
            }
            return false;
        }
        if (this.isStrictValue() && !(bl = this.getOriginValue().trim().equals(checkIt.getOriginValue().trim()))) {
            this.setComment(XXXXX_STRICT_VALUE_MISMATCH);
            return false;
        }
        return true;
    }

    @Override
    public void removeChildren() {
        this.getChildren().clear();
    }

    protected final void close(Closeable closeable) {
        StreamUtils.quietClose(closeable);
    }

    @Override
    public void encode(MemoryBuffer mb_all) {
        mb_all.append(this.getEncodeAddedLengthType());
        mb_all.append(this.getEncodeFormatLength());
        String[] splits = this.getTrimValue().split(SPACE);
        if (splits.length == 1 && splits[0].length() == 0) {
            return;
        }
        MemoryBuffer mb = new MemoryBuffer(splits.length * this.multiple());
        for (String iter : splits) {
            mb.append(this.encodeOneValue(iter));
        }
        if (mb.length() == this.getLength() * this.multiple()) {
            mb_all.append(mb.toBytes());
        } else if (mb.length() > this.getLength() * this.multiple()) {
            mb_all.append(mb.toBytes(), 0, this.getLength() * this.multiple());
        } else {
            mb_all.append(mb.toBytes());
            mb_all.append(new byte[this.getLength() * this.multiple() - mb.length()]);
        }
    }

    protected abstract byte[] encodeOneValue(String var1);

    protected byte[] getEncodeFormatLength() {
        byte[] b4 = ObjectConverter.int2Byte(this.getLength() * this.multiple());
        byte[] bs = new byte[this.getEncodingLength123()];
        System.arraycopy(b4, b4.length - bs.length, bs, 0, bs.length);
        return bs;
    }

    protected byte getEncodeAddedLengthType() {
        return (byte)(this.getType() + this.getEncodingLength123());
    }

    private int getEncodingLength123() {
        int length = this.getLength() * this.multiple();
        if (length <= 255) {
            return 1;
        }
        if (length <= 65025) {
            return 2;
        }
        return 3;
    }

    @Override
    public byte[] getArrays() {
        return new byte[0];
    }

    @Override
    public void setArrays(byte[] arrays) {
    }
}

