/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.hsms.format;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import kr.floware.hsms.format.AbstractFormat;

public class Float4Format
extends AbstractFormat {
    public static final int TYPE = 144;

    @Override
    public int getType() {
        return 144;
    }

    @Override
    public String getLogType() {
        return "F4";
    }

    @Override
    protected byte[] encodeOneValue(String iter) {
        float f = Float.parseFloat(iter);
        return this.float2Byte(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] float2Byte(float data) {
        ByteArrayOutputStream b = new ByteArrayOutputStream(4);
        try {
            DataOutputStream dos = new DataOutputStream(b);
            dos.writeFloat(data);
            dos.close();
            byte[] byArray = b.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            byte[] byArray = b.toByteArray();
            return byArray;
        }
        finally {
            this.close(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String byte2FloatString(byte[] a4Bytes) {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(a4Bytes));
        try {
            String string = String.valueOf(dis.readFloat());
            return string;
        }
        catch (Exception e) {
            String string = "0";
            return string;
        }
        finally {
            this.close(dis);
        }
    }

    private final String byte2Float4(byte[] bs) {
        switch (bs.length) {
            case 0: {
                return "";
            }
            case 4: {
                return this.byte2FloatString(bs);
            }
        }
        byte[] a = new byte[4];
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < bs.length / 4; ++i) {
            System.arraycopy(bs, i * 4, a, 0, 4);
            sb.append(this.byte2FloatString(a) + " ");
        }
        return sb.toString().trim();
    }

    @Override
    public int valueCopy(byte[] bs, int pos) {
        int length = this.getLength() * 4;
        byte[] bs2 = new byte[length];
        System.arraycopy(bs, pos, bs2, 0, length);
        this.setValue(this.byte2Float4(bs2));
        return pos += length;
    }

    @Override
    protected int multiple() {
        return 4;
    }
}

