/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.hsms.format;

import java.util.List;
import kr.floware.hsms.format.AbstractFormat;
import kr.floware.hsms.format.Format;
import kr.floware.hsms.format.Formatter;
import kr.floware.hsms.format.SFMessage;
import kr.floware.utils.MemoryBuffer;

class FormatVisitor {
    FormatVisitor() {
    }

    boolean isWellKnown(Format origin, Format checkIt) {
        for (int i = 0; i < origin.getChildren().size(); ++i) {
            if (origin.getChild(i).isWellKnown(checkIt.getChild(i))) continue;
            return false;
        }
        return true;
    }

    public void decoding(byte[] bs, SFMessage msg) {
        int pos = 0;
        Format parent = msg;
        while (pos < bs.length) {
            byte type = bs[pos];
            Format format = Formatter.newInstance(type);
            format.setFixedLength(true);
            pos = ((AbstractFormat)format).decoding(bs, pos);
            parent.add(format);
            if (!format.isListFormat()) continue;
            parent = format;
        }
    }

    public byte[] encodeBody(List<Format> formats) {
        MemoryBuffer mb = new MemoryBuffer();
        for (Format format : formats) {
            format.encode(mb);
        }
        return mb.toBytes();
    }

    public void setIndex(List<Format> formats) {
        int level = 0;
        for (Format format : formats) {
            format.setIndex(level);
        }
    }

    public void copyNames(List<Format> origins, List<Format> requires) {
        for (int i = 0; i < origins.size(); ++i) {
            origins.get(i).copyNames(requires.get(i));
        }
    }
}

