/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.hsms.format;

import kr.floware.hsms.format.AsciiFormat;
import kr.floware.hsms.format.BinaryFormat;
import kr.floware.hsms.format.BooleanFormat;
import kr.floware.hsms.format.Float4Format;
import kr.floware.hsms.format.Float8Format;
import kr.floware.hsms.format.Format;
import kr.floware.hsms.format.Int1Format;
import kr.floware.hsms.format.Int2Format;
import kr.floware.hsms.format.Int4Format;
import kr.floware.hsms.format.Int8Format;
import kr.floware.hsms.format.JisFormat;
import kr.floware.hsms.format.ListFormat;
import kr.floware.hsms.format.SFMessage;
import kr.floware.hsms.format.Uint1Format;
import kr.floware.hsms.format.Uint2Format;
import kr.floware.hsms.format.Uint4Format;
import kr.floware.hsms.format.Uint8Format;
import kr.floware.hsms.format.XFormat;

class Formatter {
    Formatter() {
    }

    public static Format newInstance(int type) {
        switch (type & 0xFF) {
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                return new AsciiFormat();
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return new ListFormat();
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                return new BooleanFormat();
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                return new BinaryFormat();
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                return new Int1Format();
            }
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                return new Int2Format();
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                return new Int4Format();
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                return new Int8Format();
            }
            case 164: 
            case 165: 
            case 166: 
            case 167: {
                return new Uint1Format();
            }
            case 168: 
            case 169: 
            case 170: 
            case 171: {
                return new Uint2Format();
            }
            case 176: 
            case 177: 
            case 178: 
            case 179: {
                return new Uint4Format();
            }
            case 160: 
            case 161: 
            case 162: 
            case 163: {
                return new Uint8Format();
            }
            case 144: 
            case 145: 
            case 146: 
            case 147: {
                return new Float4Format();
            }
            case 128: 
            case 129: 
            case 130: 
            case 131: {
                return new Float8Format();
            }
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                return new JisFormat();
            }
        }
        return new SFMessage();
    }

    public static Format newInstance(String type) {
        if (type.equals("A")) {
            return new AsciiFormat();
        }
        if (type.equals("L")) {
            return new ListFormat();
        }
        if (type.equals("BOOLEAN")) {
            return new BooleanFormat();
        }
        if (type.equals("B")) {
            return new BinaryFormat();
        }
        if (type.equals("I1")) {
            return new Int1Format();
        }
        if (type.equals("I2")) {
            return new Int2Format();
        }
        if (type.equals("I4")) {
            return new Int4Format();
        }
        if (type.equals("I8")) {
            return new Int8Format();
        }
        if (type.equals("U1")) {
            return new Uint1Format();
        }
        if (type.equals("U2")) {
            return new Uint2Format();
        }
        if (type.equals("U4")) {
            return new Uint4Format();
        }
        if (type.equals("U8")) {
            return new Uint8Format();
        }
        if (type.equals("F4")) {
            return new Float4Format();
        }
        if (type.equals("F8")) {
            return new Float8Format();
        }
        if (type.equals("J")) {
            return new JisFormat();
        }
        if (type.equals("X")) {
            return new XFormat();
        }
        return new SFMessage();
    }
}

