/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.hsms.format;

import kr.floware.hsms.format.AbstractFormat;
import kr.floware.hsms.format.BytesConverter;
import kr.floware.utils.Assert;

public class Int1Format
extends AbstractFormat {
    public static final int TYPE = 100;

    public Int1Format() {
    }

    public Int1Format(int value) {
        boolean range = value >= -128 || value <= 127;
        Assert.isTrue(range, "I1 Format Support -128~127", new Object[0]);
        this.setLength(1);
        this.setValue(String.valueOf(value));
    }

    @Override
    public int getType() {
        return 100;
    }

    @Override
    public String getLogType() {
        return "I1";
    }

    @Override
    protected byte[] encodeOneValue(String iter) {
        int v = Integer.parseInt(iter);
        Assert.isTrue(v >= -128, "%s invalid value -128~127", this.getName());
        Assert.isTrue(v <= 127, "%s invalid value -128~127", this.getName());
        return new byte[]{(byte)v};
    }

    @Override
    public int valueCopy(byte[] bs, int pos) {
        byte[] bs2 = new byte[this.getLength()];
        System.arraycopy(bs, pos, bs2, 0, this.getLength());
        this.setValue(BytesConverter.byte2Int1(bs2));
        return pos += this.getLength();
    }
}

