/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.hsms.format;

import kr.floware.hsms.format.AbstractFormat;
import kr.floware.hsms.format.BytesConverter;
import kr.floware.utils.Assert;

public class Uint1Format
extends AbstractFormat {
    public static final int TYPE = 164;

    public Uint1Format() {
    }

    public Uint1Format(int value) {
        boolean bl = value < 0 || value > 255;
        Assert.isFalse(bl, "U1 Format Support 0~255, input %d", value);
        this.setLength(1);
        this.setValue(String.valueOf(value));
    }

    @Override
    public int getType() {
        return 164;
    }

    @Override
    public String getLogType() {
        return "U1";
    }

    @Override
    protected byte[] encodeOneValue(String iter) {
        int v = Integer.parseInt(iter);
        Assert.isTrue(v > -1, "%s's binary value >= 0", this.getName());
        Assert.isTrue(v < 256, "%s's binary value <= 255", this.getName());
        return new byte[]{(byte)v};
    }

    @Override
    public int valueCopy(byte[] bs, int pos) {
        byte[] bs2 = new byte[this.getLength()];
        System.arraycopy(bs, pos, bs2, 0, this.getLength());
        this.setValue(BytesConverter.byte2Uint1(bs2));
        return pos += this.getLength();
    }
}

