/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import kr.floware.logging.LogbackFile;
import org.slf4j.LoggerFactory;

public class LogUtils {
    static final String DEF_PATTERN = "%d{MM-dd HH:mm:ss.SSS} %-5p %-10t %m%n";

    public static LoggerContext getRootCtx() {
        return (LoggerContext)LoggerFactory.getILoggerFactory();
    }

    public static LoggerContext getCtx(String name) {
        LoggerContext lc = new LoggerContext();
        lc.setName(name);
        return lc;
    }

    public static Logger getLogger() {
        return LogUtils.getRootCtx().getLogger("ROOT");
    }

    public static Logger getLogger(String name) {
        return LogUtils.getRootCtx().getLogger(name);
    }

    public static void chgLevel(Level level) {
        LogUtils.getLogger().setLevel(level);
    }

    static Encoder getDefEncoder(String pattern) {
        PatternLayoutEncoder e = new PatternLayoutEncoder();
        e.setPattern(pattern);
        return e;
    }

    public static void addFileAppender(LogbackFile lbfile) {
        LoggerContext ctx = lbfile.hasCtxName() ? LogUtils.getCtx(lbfile.getCtxName()) : LogUtils.getRootCtx();
        Logger logger = lbfile.hasLoggerName() ? LogUtils.getLogger(lbfile.getLoggerName()) : LogUtils.getLogger();
        logger.setAdditive(lbfile.isAdditive());
        Encoder e = LogUtils.getDefEncoder(lbfile.getPattern());
        e.setContext((Context)ctx);
        e.start();
        RollingFileAppender rfa = new RollingFileAppender();
        rfa.setContext((Context)ctx);
        rfa.setName(lbfile.getName());
        rfa.setPrudent(lbfile.isPrudent());
        TimeBasedRollingPolicy pol = new TimeBasedRollingPolicy();
        pol.setContext((Context)ctx);
        pol.setMaxHistory(lbfile.getMaxHistory());
        pol.setFileNamePattern(lbfile.getFileNamePattern());
        pol.setParent((FileAppender)rfa);
        pol.start();
        rfa.setRollingPolicy((RollingPolicy)pol);
        rfa.setEncoder(e);
        rfa.start();
        logger.addAppender((Appender)rfa);
    }
}

