/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.logging;

import kr.floware.utils.ErrorUtils;
import org.slf4j.LoggerFactory;

public class Logger {
    org.slf4j.Logger logger;

    private Logger() {
    }

    public static Logger getLogger() {
        StackTraceElement[] v = Thread.currentThread().getStackTrace();
        return Logger.getLogger(v[2].getClassName());
    }

    public static Logger getLogger(Class<?> clazz) {
        return Logger.getLogger(clazz.getName());
    }

    public static Logger getLogger(String name) {
        Logger log = new Logger();
        log.logger = LoggerFactory.getLogger((String)name);
        return log;
    }

    private String newF(String format) {
        return format.replaceAll("%[sd]", "{}");
    }

    public boolean isDe() {
        return this.logger.isDebugEnabled();
    }

    public void d(Object message) {
        if (this.isDe()) {
            this.d("{}", message);
        }
    }

    public void d(String format, Object ... args) {
        if (this.isDe()) {
            if (args.length > 0) {
                this.logger.debug(this.newF(format), args);
            } else {
                this.logger.debug(format);
            }
        }
    }

    public void i(Object message) {
        if (this.logger.isInfoEnabled()) {
            this.i("{}", message);
        }
    }

    public void i(String format, Object ... args) {
        if (this.logger.isInfoEnabled()) {
            if (args.length > 0) {
                this.logger.info(this.newF(format), args);
            } else {
                this.logger.info(format);
            }
        }
    }

    public void w(Object message) {
        this.w("{}", message);
    }

    public void w(Throwable throwable) {
        this.w(ErrorUtils.getErrorStack(throwable));
    }

    public void w(String format, Object ... args) {
        this.logger.warn(this.newF(format), args);
    }

    public void e(Object message) {
        this.e("{}", message);
    }

    public void e(Throwable throwable) {
        this.e(ErrorUtils.getErrorStack(throwable));
    }

    public void e(String format, Object ... args) {
        this.logger.error(this.newF(format), args);
    }
}

