/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.plc;

import java.util.Comparator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import kr.floware.concurrent.BoundQueue;
import kr.floware.plc.BitBlock;
import kr.floware.plc.PlcBlock;
import kr.floware.plc.PlcGroup;
import kr.floware.plc.PlcListener;
import kr.floware.plc.QueueCmd;
import kr.floware.plc.WordBlock;
import kr.floware.plc.WordFormat;
import kr.floware.utils.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PlcConnector {
    protected static int[] ONs = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 1, 2, 4, 8, 16, 32, 64, 128};
    protected Logger logger = LoggerFactory.getLogger(PlcConnector.class);
    private PlcListener plcListener;
    private String id = "PLC001";
    private String ipAddress = "127.0.0.1";
    private int port;
    private int pollingTime = 300;
    private BoundQueue<Object> sendQ = new BoundQueue();
    private BoundQueue<PlcBlock> eventQ = new BoundQueue();
    private ConcurrentMap<String, PlcGroup> groups = new ConcurrentHashMap<String, PlcGroup>();
    private ConcurrentMap<String, BitBlock> bits = new ConcurrentHashMap<String, BitBlock>();
    private ConcurrentMap<String, WordBlock> words = new ConcurrentHashMap<String, WordBlock>();
    private static Timer jdkTimer = new Timer("PlcTimer", true);
    private Thread threadEventQ;
    private Thread threadSendQ;
    private boolean connecting;

    public ConcurrentMap<String, PlcGroup> getGroups() {
        return this.groups;
    }

    public int getSendQueueSize() {
        return this.sendQ.size();
    }

    public int getEventQueueSize() {
        return this.eventQ.size();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public int getPollingTime() {
        return this.pollingTime;
    }

    public void setPollingTime(int time) {
        this.pollingTime = time;
    }

    public PlcListener getPlcListener() {
        return this.plcListener;
    }

    public void setPlcListener(PlcListener plcListener) {
        this.plcListener = plcListener;
    }

    public void addGroup(PlcGroup group) {
        Assert.isTrue(!this.groups.containsKey(group.getName()), String.format("Duplicate group name %s", group.getName()), new Object[0]);
        this.groups.put(group.getName(), group);
    }

    public boolean isConnecting() {
        return this.connecting;
    }

    public boolean connect() {
        Assert.notNull(this.getPlcListener(), "PlcListener is null", new Object[0]);
        Assert.isTrue(!this.isConnecting(), String.format("[%s] already connecting", this.getId()), new Object[0]);
        this.logger = LoggerFactory.getLogger((String)this.getId());
        this.connecting = true;
        this.groups.values().forEach(x -> x.arrange());
        this.groups.values().forEach(x -> x.getTokens().forEach(y -> this.logger.info(y.toString())));
        this.bits = this.groups.values().stream().filter(x -> x.isBitType()).flatMap(x -> x.getAddedBlocks().values().stream()).map(BitBlock.class::cast).collect(Collectors.toConcurrentMap(PlcBlock::getName, x -> x));
        this.words = this.groups.values().stream().filter(x -> !x.isBitType()).flatMap(x -> x.getAddedBlocks().values().stream()).map(WordBlock.class::cast).collect(Collectors.toConcurrentMap(PlcBlock::getName, x -> x));
        this.bits.values().forEach(x -> x.setPlcId(this.getId()));
        this.words.values().forEach(x -> x.setPlcId(this.getId()));
        this.threadEventQ = new Thread(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setName(String.format("%s@EventQ@%d", PlcConnector.this.getId(), Thread.currentThread().getId()));
                while (PlcConnector.this.connecting) {
                    try {
                        PlcBlock cp;
                        Object deq = PlcConnector.this.eventQ.dequeueThrow();
                        if (deq instanceof BitBlock) {
                            BitBlock bit = (BitBlock)deq;
                            cp = bit.copy();
                            PlcConnector.this.getPlcListener().onBitChanged((BitBlock)cp);
                            continue;
                        }
                        if (!(deq instanceof WordBlock)) continue;
                        WordBlock wd = (WordBlock)deq;
                        cp = wd.copy();
                        PlcConnector.this.getPlcListener().onWordChanged((WordBlock)cp);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    catch (Exception e) {
                        PlcConnector.this.logger.error(e.toString());
                    }
                    catch (Error e) {
                        PlcConnector.this.logger.error(e.toString());
                    }
                }
            }
        });
        this.threadEventQ.start();
        this.threadSendQ = new Thread(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setName(String.format("%s@SendQ@%d", PlcConnector.this.getId(), Thread.currentThread().getId()));
                while (PlcConnector.this.connecting) {
                    try {
                        QueueCmd qc;
                        if (!PlcConnector.this.wasConnected()) {
                            Thread.sleep(1000L);
                            continue;
                        }
                        Object obj = PlcConnector.this.sendQ.dequeueThrow();
                        if (obj instanceof PlcGroup) {
                            PlcGroup grp2 = (PlcGroup)obj;
                            PlcConnector.this.readGroup(grp2);
                            continue;
                        }
                        if (obj instanceof BitBlock) {
                            BitBlock bitBlock = (BitBlock)obj;
                            PlcConnector.this.writeBit(bitBlock);
                            continue;
                        }
                        if (obj instanceof WordBlock) {
                            WordBlock wordBlock = (WordBlock)obj;
                            PlcConnector.this.writeWord(wordBlock);
                            continue;
                        }
                        if (!(obj instanceof QueueCmd) || (qc = (QueueCmd)((Object)obj)) != QueueCmd.CHECK_CHGD) continue;
                        PlcConnector.this.groups.values().stream().sorted(Comparator.comparing(PlcGroup::isBitType)).collect(Collectors.toList()).forEach(grp -> {
                            if (grp.isFirstChanged()) {
                                grp.setFirstChanged(false);
                                grp.getOrders().forEach(x -> {
                                    x.setChanged(false);
                                    PlcConnector.this.eventQ.enqueue(x);
                                });
                            } else {
                                grp.getOrders().stream().filter(x -> x.isChanged()).forEach(x -> {
                                    x.setChanged(false);
                                    PlcConnector.this.eventQ.enqueue(x);
                                });
                            }
                        });
                        jdkTimer.schedule(new TimerTask(){

                            @Override
                            public void run() {
                                PlcConnector.this.readGroups();
                                this.cancel();
                            }
                        }, PlcConnector.this.getPollingTime());
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    catch (Exception e) {
                        PlcConnector.this.logger.error(e.toString());
                    }
                    catch (Error e) {
                        PlcConnector.this.logger.error(e.toString());
                    }
                }
            }
        });
        this.threadSendQ.start();
        return true;
    }

    protected abstract boolean wasConnected();

    public BitBlock readBit(String name) {
        Assert.isTrue(this.bits.containsKey(name), String.format("Not exist bit name %s", name), new Object[0]);
        return ((BitBlock)this.bits.get(name)).copy();
    }

    public WordBlock readWord(String name) {
        Assert.isTrue(this.words.containsKey(name), String.format("Not exist word name %s", name), new Object[0]);
        return ((WordBlock)this.words.get(name)).copy();
    }

    private void readGroups() {
        for (PlcGroup group : this.groups.values()) {
            if (!group.isBitType()) continue;
            this.sendQ.enqueue(group);
        }
        for (PlcGroup group : this.groups.values()) {
            if (group.isBitType()) continue;
            this.sendQ.enqueue(group);
        }
        this.sendQ.enqueue((Object)QueueCmd.CHECK_CHGD);
    }

    public boolean disconnect() {
        Assert.isTrue(this.isConnecting(), String.format("[%s] not connecting", this.getId()), new Object[0]);
        this.connecting = false;
        this.threadSendQ.interrupt();
        this.threadEventQ.interrupt();
        return true;
    }

    protected abstract void writeBit(BitBlock var1);

    protected abstract void writeWord(WordBlock var1);

    protected abstract void readGroup(PlcGroup var1);

    public void writeBit(String name, boolean on) {
        Assert.isTrue(this.bits.containsKey(name), String.format("Not exist bit name %s", name), new Object[0]);
        BitBlock cp = this.readBit(name);
        cp.setBitOn(on);
        this.sendQ.enqueue(cp);
    }

    public void writeWord(String name, String value) {
        Assert.isTrue(this.words.containsKey(name), String.format("Not exist word name %s", name), new Object[0]);
        WordBlock cp = this.readWord(name);
        if (cp.getRatio() > 1 && (cp.getFormat() == WordFormat.N || cp.getFormat() == WordFormat.SI)) {
            cp.setOrgValue(String.valueOf((int)(Double.parseDouble(value) * (double)cp.getRatio())));
        } else if (cp.getRatio() > 1 && cp.getFormat() == WordFormat.F) {
            cp.setOrgValue(String.valueOf(Double.parseDouble(value) * (double)cp.getRatio()));
        } else {
            cp.setOrgValue(value);
        }
        this.sendQ.enqueue(cp);
    }

    protected void onContd() {
        this.readGroups();
        this.getPlcListener().onConnected(this.getId());
    }
}

