/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.plc;

import kr.floware.plc.PlcBlock;
import kr.floware.plc.WordFormat;

public abstract class WordBlock
extends PlcBlock
implements Cloneable {
    private int ratio = 1;
    private String value = "0";
    private WordFormat format = WordFormat.N;
    private byte[] rawBytes = new byte[0];
    private boolean asciiSwap;

    public boolean isAsciiSwap() {
        return this.asciiSwap;
    }

    public void setAsciiSwap(boolean asciiSwap) {
        this.asciiSwap = asciiSwap;
    }

    public byte[] getRawBytes() {
        return this.rawBytes;
    }

    public void setRawBytes(byte[] rawBytes) {
        this.rawBytes = rawBytes;
    }

    public int getRatio() {
        return this.ratio;
    }

    public void setRatio(int ratio) {
        this.ratio = ratio;
    }

    public WordFormat getFormat() {
        return this.format;
    }

    public void setFormat(WordFormat format) {
        this.format = format;
    }

    public int getIntValue() {
        return this.getRatio() == 1 ? Integer.parseInt(this.getValue()) : this.getDoubleIntValue();
    }

    public int getOrgIntValue() {
        return Integer.parseInt(this.getOrgValue());
    }

    public String getOrgValue() {
        return this.value;
    }

    int getDoubleIntValue() {
        return (int)Double.parseDouble(this.getValue());
    }

    public String getValue() {
        return this.getRatio() > 1 ? String.valueOf(Double.parseDouble(this.value) / (double)this.getRatio()) : this.value;
    }

    public void setDecodeValue(String value) {
        this.setChanged(!value.equals(this.value));
        this.value = value;
    }

    public void setOrgValue(String value) {
        this.value = value;
    }

    public abstract void decode(byte ... var1);

    public abstract byte[] encode();

    public WordBlock copy() {
        try {
            return (WordBlock)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("WordBlock copy error");
        }
    }
}

