/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.plc.smlp;

import java.io.IOException;
import kr.floware.plc.BitBlock;
import kr.floware.plc.PlcBlock;
import kr.floware.plc.PlcConnector;
import kr.floware.plc.PlcGroup;
import kr.floware.plc.PlcToken;
import kr.floware.plc.WordBlock;
import kr.floware.plc.smlp.KncBitBlock;
import kr.floware.plc.smlp.KncGroup;
import kr.floware.plc.smlp.KncMemory;
import kr.floware.plc.smlp.KncWordBlock;
import kr.floware.socket.TcpSocket;
import kr.floware.utils.Assert;
import kr.floware.utils.BitUtils;
import kr.floware.utils.MemoryBuffer;

public class KncConnector
extends PlcConnector {
    static final int MAX_BIT = 7000;
    static final int MAX_WD = 900;
    static byte[] READ = new byte[]{1, 4};
    static byte[] WRITE = new byte[]{1, 20};
    static byte[] BIT = new byte[]{1, 0};
    static byte[] WORD = new byte[]{0, 0};
    static byte[] HEAD = new byte[]{80, 0, 0, -1, -1, 3, 0};
    private TcpSocket tcp = new TcpSocket();

    @Override
    public boolean connect() {
        super.connect();
        return true;
    }

    private boolean tryComm() {
        if (this.tcp.isConnected()) {
            return true;
        }
        this.tcp.close();
        this.tcp.setIpAddress(this.getIpAddress());
        this.tcp.setPort(this.getPort());
        this.tcp.tryConnect(this.getId());
        this.tcp.setTimeout(5000);
        if (this.tcp.isConnected()) {
            super.onContd();
        }
        return this.tcp.isConnected();
    }

    @Override
    public boolean disconnect() {
        super.disconnect();
        this.tcp.close();
        if (this.getPlcListener() != null) {
            this.getPlcListener().onDisconnected(this.getId());
        }
        return true;
    }

    @Override
    protected boolean wasConnected() {
        if (this.tcp.isConnected()) {
            return true;
        }
        return this.tryComm();
    }

    @Override
    protected void writeBit(BitBlock bitBlock) {
        try {
            KncMemory d = ((KncGroup)bitBlock.getPlcGroup()).getMemory();
            MemoryBuffer mb = new MemoryBuffer(64);
            mb.append(HEAD);
            int lenW = 13;
            mb.appendLeUshort(lenW);
            mb.append(0, 0);
            mb.append(WRITE);
            mb.append(BIT);
            byte[] lenbs = BitUtils.reverse(BitUtils.putInt(bitBlock.getAddress()));
            mb.append(lenbs, 0, 3);
            mb.append(d.getCode());
            mb.appendLeUshort(1);
            mb.append(bitBlock.isBitOn() ? 16 : 0);
            this.tcp.send(mb.toBytes());
            byte[] byArray = this.tcp.read(11);
        }
        catch (IOException e) {
            this.logger.warn(e.getMessage());
            this.tcp.close();
        }
    }

    @Override
    protected void writeWord(WordBlock wordBlock) {
        KncMemory d = ((KncGroup)wordBlock.getPlcGroup()).getMemory();
        this.writeArray(d, wordBlock.getAddress(), wordBlock.encode());
    }

    public synchronized void writeArray(KncMemory d, int address, byte[] bs) {
        try {
            MemoryBuffer mb = new MemoryBuffer(64);
            mb.append(HEAD);
            int lenW = 12 + bs.length;
            mb.appendLeUshort(lenW);
            mb.append(0, 0);
            mb.append(WRITE);
            mb.append(WORD);
            byte[] lenbs = BitUtils.reverse(BitUtils.putInt(address));
            mb.append(lenbs, 0, 3);
            mb.append(d.getCode());
            mb.appendLeUshort(bs.length / 2);
            mb.append(bs);
            this.tcp.send(mb.toBytes());
            byte[] byArray = this.tcp.read(11);
        }
        catch (IOException e) {
            this.logger.warn(e.getMessage());
            this.tcp.close();
        }
    }

    protected synchronized byte[] readBit(KncMemory d, int addr, int point) throws IOException {
        if (point < 1) {
            return new byte[0];
        }
        MemoryBuffer mb = new MemoryBuffer(64);
        mb.append(HEAD);
        int lenW = 12;
        mb.appendLeUshort(lenW);
        mb.append(0, 0);
        mb.append(READ);
        mb.append(BIT);
        byte[] lenbs = BitUtils.reverse(BitUtils.putInt(addr));
        mb.append(lenbs, 0, 3);
        mb.append(d.getCode());
        mb.appendLeUshort(point);
        this.tcp.send(mb.toBytes());
        byte[] rep = this.tcp.read(11);
        MemoryBuffer mbRd = new MemoryBuffer();
        mbRd.append(rep);
        mbRd.chgPos(7);
        int length = mbRd.readLeShort();
        int errcode = mbRd.readLeShort();
        Assert.isTrue(errcode == 0, String.format("Keyence nak 0x%X", errcode), new Object[0]);
        return this.enlargeBits(this.tcp.read(length - 2));
    }

    byte[] enlargeBits(byte[] org) {
        byte[] bs = new byte[org.length * 2];
        for (int i = 0; i < org.length; ++i) {
            byte b = org[i];
            bs[i * 2] = (byte)(b >> 4);
            bs[i * 2 + 1] = (byte)(b & 1);
        }
        return bs;
    }

    protected synchronized byte[] readWord(KncMemory d, int wddr, int point) throws IOException {
        if (point < 1) {
            return new byte[0];
        }
        MemoryBuffer mb = new MemoryBuffer(64);
        mb.append(HEAD);
        int lenW = 12;
        mb.appendLeUshort(lenW);
        mb.append(0, 0);
        mb.append(READ);
        mb.append(WORD);
        byte[] lenbs = BitUtils.reverse(BitUtils.putInt(wddr));
        mb.append(lenbs, 0, 3);
        mb.append(d.getCode());
        mb.appendLeUshort(point);
        this.tcp.send(mb.toBytes());
        byte[] rep = this.tcp.read(11);
        MemoryBuffer mbRd = new MemoryBuffer();
        mbRd.append(rep);
        mbRd.chgPos(7);
        int wdLength = mbRd.readLeShort();
        int errcode = mbRd.readLeShort();
        Assert.isTrue(errcode == 0, String.format("Keyence nak 0x%X", errcode), new Object[0]);
        return this.tcp.read(wdLength - 2);
    }

    @Override
    protected void readGroup(PlcGroup group) {
        try {
            int i;
            int div;
            int space;
            KncGroup grpKnc = (KncGroup)group;
            KncMemory d = grpKnc.getMemory();
            MemoryBuffer all = new MemoryBuffer(4096);
            int start = group.getTokens().get(0).getAddress();
            if (d.isBitMemory()) {
                for (PlcToken plcToken : group.getTokens()) {
                    space = plcToken.getAddress() - start - all.length();
                    all.append(new byte[space]);
                    div = plcToken.getPoint() / 7000;
                    for (i = 0; i < div; ++i) {
                        all.append(this.readBit(d, plcToken.getAddress() + i * 7000, 7000));
                    }
                    all.append(this.readBit(d, plcToken.getAddress() + div * 7000, plcToken.getPoint() - div * 7000));
                }
            } else {
                for (PlcToken plcToken : group.getTokens()) {
                    space = (plcToken.getAddress() - start) * 2 - all.length();
                    all.append(new byte[space]);
                    div = plcToken.getPoint() / 900;
                    for (i = 0; i < div; ++i) {
                        all.append(this.readWord(d, plcToken.getAddress() + i * 900, 900));
                    }
                    all.append(this.readWord(d, plcToken.getAddress() + div * 900, plcToken.getPoint() - div * 900));
                }
            }
            if (d.isBitMemory()) {
                byte[] allbs = all.toBytes();
                for (PlcBlock x2 : group.getOrders()) {
                    KncBitBlock bb;
                    bb.decode(allbs[(bb = (KncBitBlock)x2).getAddress() - start] == 1);
                }
            } else if (group.isBitType()) {
                for (PlcBlock plcBlock : group.getOrders()) {
                    KncBitBlock bb = (KncBitBlock)plcBlock;
                    all.chgPos((bb.getAddress() - start) * 2);
                    byte[] bs = all.read(2);
                    byte b = bb.getBitIndex() < 8 ? bs[0] : bs[1];
                    int calc = b & ONs[bb.getBitIndex()];
                    bb.decode(calc == ONs[bb.getBitIndex()]);
                }
            } else {
                group.getOrders().forEach(x -> {
                    KncWordBlock wd = (KncWordBlock)x;
                    all.chgPos((wd.getAddress() - start) * 2);
                    wd.decode(all.read(wd.getPoint() * 2));
                });
            }
        }
        catch (IOException e) {
            this.logger.error(e.toString());
            this.tcp.close();
        }
    }
}

