/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.plc.smlp;

import kr.floware.plc.WordBlock;
import kr.floware.plc.WordFormat;
import kr.floware.plc.smlp.KncGroup;
import kr.floware.utils.BitUtils;

public class KncWordBlock
extends WordBlock {
    public String toString() {
        KncGroup g = (KncGroup)this.getPlcGroup();
        return String.format("%s[%s.%d] %s %s %s", g == null ? "" : g.getMemory(), this.getAddress(), this.getPoint(), this.getName(), this.getValue(), this.getPlcId());
    }

    @Override
    public void decode(byte ... bs) {
        this.setRawBytes(bs);
        if (this.getFormat() == WordFormat.N) {
            if (this.getPoint() == 1) {
                this.setDecodeValue(String.valueOf(BitUtils.getUshort(BitUtils.reverse(bs))));
            } else if (this.getPoint() == 2) {
                this.setDecodeValue(String.valueOf(BitUtils.getInt(BitUtils.reverse(bs))));
            }
        } else if (this.getFormat() == WordFormat.SI) {
            if (this.getPoint() == 1) {
                this.setDecodeValue(String.valueOf(BitUtils.getShort(BitUtils.reverse(bs))));
            } else if (this.getPoint() == 2) {
                this.setDecodeValue(String.valueOf(BitUtils.getInt(BitUtils.reverse(bs))));
            }
        } else if (this.getFormat() == WordFormat.F) {
            this.setDecodeValue(String.valueOf(BitUtils.getFloat(BitUtils.reverse(bs))));
        } else {
            for (int i = 0; i < bs.length; ++i) {
                if (bs[i] != 0) continue;
                bs[i] = 32;
            }
            byte[] swap = this.isAsciiSwap() ? BitUtils.middle2(bs) : bs;
            this.setDecodeValue(new String(swap));
        }
    }

    @Override
    public byte[] encode() {
        if (this.getFormat() == WordFormat.N) {
            if (this.getPoint() == 1) {
                return BitUtils.reverse(BitUtils.putUshort(this.getOrgIntValue()));
            }
            if (this.getPoint() == 2) {
                return BitUtils.reverse(BitUtils.putInt(this.getOrgIntValue()));
            }
        } else if (this.getFormat() == WordFormat.SI) {
            if (this.getPoint() == 1) {
                return BitUtils.reverse(BitUtils.putShort(this.getOrgIntValue()));
            }
            if (this.getPoint() == 2) {
                return BitUtils.reverse(BitUtils.putInt(this.getOrgIntValue()));
            }
        } else if (this.getFormat() == WordFormat.F) {
            return BitUtils.reverse(BitUtils.putFloat(Float.parseFloat(this.getOrgValue())));
        }
        byte[] asc = this.getValue().getBytes();
        byte[] pad = new byte[this.getPoint() * 2];
        for (int i = 0; i < pad.length; ++i) {
            pad[i] = 32;
        }
        System.arraycopy(asc, 0, pad, 0, asc.length > pad.length ? pad.length : asc.length);
        return this.isAsciiSwap() ? BitUtils.middle2(pad) : pad;
    }
}

