/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.quartz;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import kr.floware.logging.Logger;
import kr.floware.quartz.TimerListener;
import kr.floware.quartz.TimerTaskOperation;
import kr.floware.utils.Assert;
import kr.floware.utils.ErrorUtils;

public class TimerTemplate<I, A> {
    private static Logger logger = Logger.getLogger();
    private Timer jdkTimer;
    private List<TimerListener<I, A>> timerListeners = new CopyOnWriteArrayList<TimerListener<I, A>>();
    private Map<I, TimerTaskOperation<I, A>> taskOperationos = new ConcurrentHashMap<I, TimerTaskOperation<I, A>>();
    private Object lock1 = new Object();

    public TimerTemplate() {
        this.jdkTimer = new Timer(true);
    }

    public TimerTemplate(String name) {
        this.jdkTimer = new Timer(name, true);
    }

    public boolean hasId(I id) {
        return this.taskOperationos.containsKey(id);
    }

    public Set<I> getIds() {
        return this.taskOperationos.keySet();
    }

    private List<TimerListener<I, A>> getTimerListeners() {
        return this.timerListeners;
    }

    public boolean hasTimerListeners() {
        return !this.getTimerListeners().isEmpty();
    }

    public A getAttachment(I id) {
        return this.taskOperationos.get(id).getAttachment();
    }

    public void addTimerListeners(TimerListener<I, A> timerListener) {
        if (this.getTimerListeners().contains(timerListener)) {
            return;
        }
        this.getTimerListeners().add(timerListener);
    }

    public void removeTimerListener(TimerListener<I, A> timerListener) {
        this.getTimerListeners().remove(timerListener);
    }

    private void checkPrevSchedule(I id) {
        Assert.notEmpty(this.getTimerListeners(), "TimerListener more than 0", new Object[0]);
        if (this.taskOperationos.containsKey(id)) {
            logger.d("TimerTemplate duplicate start '%s'", id);
            this.stop(id);
        }
    }

    public void startOnce(int intervalMills, I id) {
        this.startOnce(intervalMills, id, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startOnce(int intervalMills, final I id, final A attachment) {
        Object object = this.lock1;
        synchronized (object) {
            this.checkPrevSchedule(id);
            TimerTaskOperation timerTaskOperation = new TimerTaskOperation<I, A>(){

                @Override
                public void run() {
                    TimerTemplate.this.notifyListenersOnce(id, attachment);
                }
            };
            timerTaskOperation.setAttachment(attachment);
            timerTaskOperation.setId(id);
            this.taskOperationos.put(id, timerTaskOperation);
            this.jdkTimer.schedule((TimerTask)timerTaskOperation, intervalMills);
        }
    }

    public void startRepeat(int msec, I id) {
        this.startRepeat(msec, id, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRepeat(int msec, final I id, final A attachment) {
        Object object = this.lock1;
        synchronized (object) {
            this.checkPrevSchedule(id);
            TimerTaskOperation timerTaskOperation = new TimerTaskOperation<I, A>(){

                @Override
                public void run() {
                    TimerTemplate.this.notifyListeners(id, attachment);
                }
            };
            timerTaskOperation.setId(id);
            timerTaskOperation.setAttachment(attachment);
            this.taskOperationos.put(id, timerTaskOperation);
            this.jdkTimer.schedule((TimerTask)timerTaskOperation, msec, (long)msec);
        }
    }

    private void notifyListeners(I id, A attachment) {
        for (TimerListener<I, A> listener : this.getTimerListeners()) {
            try {
                listener.onTimeout(id, attachment);
            }
            catch (Exception e) {
                logger.e("TimerTemplate onTimeout error " + e.toString());
                logger.d(ErrorUtils.getErrorStack(e));
            }
        }
    }

    private void notifyListenersOnce(I id, A attachment) {
        this.notifyListeners(id, attachment);
        this.stop(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAll() {
        Object object = this.lock1;
        synchronized (object) {
            for (I id : this.taskOperationos.keySet()) {
                this.taskOperationos.get(id).cancel();
            }
            this.taskOperationos.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public A stop(I id) {
        Object object = this.lock1;
        synchronized (object) {
            if (!this.taskOperationos.containsKey(id)) {
                return null;
            }
            TimerTaskOperation<I, A> timerTaskOperation = this.taskOperationos.remove(id);
            timerTaskOperation.cancel();
            return timerTaskOperation.getAttachment();
        }
    }

    public void dispose() {
        this.stopAll();
        this.jdkTimer.cancel();
        logger.d("TimerTemplate disposed");
    }
}

