/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.socket;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.concurrent.locks.Condition;
import kr.floware.Ftil;
import kr.floware.Thread8;
import kr.floware.concurrent.Monitor;
import kr.floware.logging.Logger;
import kr.floware.utils.MemoryBuffer;

public class Udp4 {
    static Logger logger = Logger.getLogger();
    DatagramSocket sckR;
    DatagramSocket sckW;
    MemoryBuffer all = new MemoryBuffer(0x100000);
    Monitor monitor = new Monitor();
    Condition cd = this.monitor.newCondition();
    int timeout = 0;
    InetAddress clientIpaddr = null;
    int clientPort = 0;

    public void openClient(String ip, int port) {
        try {
            this.sckW = new DatagramSocket();
            this.clientIpaddr = InetAddress.getByName(ip);
            this.clientPort = port;
        }
        catch (Exception e) {
            logger.e(e);
        }
    }

    public void openServer(int port, int secondTimeout) {
        try {
            this.sckR = new DatagramSocket(port);
            this.sckR.setReceiveBufferSize(0x100000);
            this.timeout = secondTimeout;
        }
        catch (SocketException e) {
            logger.e(e);
        }
        Thread8.platform().start(this::task_read);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void task_read() {
        while (true) {
            byte[] bs = new byte[2048];
            DatagramPacket pk = new DatagramPacket(bs, bs.length);
            try {
                this.sckR.receive(pk);
                this.monitor.lock();
                this.all.append(pk.getData(), 0, pk.getLength());
                this.monitor.signalAll(this.cd);
                continue;
            }
            catch (Exception e) {
                logger.e(e);
                continue;
            }
            finally {
                this.monitor.unlock();
                continue;
            }
            break;
        }
    }

    public void send(byte ... bs) {
        try {
            DatagramPacket dp = new DatagramPacket(bs, bs.length, this.clientIpaddr, this.clientPort);
            this.sckW.send(dp);
        }
        catch (IOException e) {
            logger.e(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] read(int size) throws SocketTimeoutException {
        while (this.all.getPos() < size) {
            try {
                this.monitor.lock();
                if (this.timeout > 0) {
                    if (this.monitor.quietAwait(this.cd, this.timeout)) continue;
                    throw new SocketTimeoutException(Ftil.fff("Udp4 read timeout length(%d)", size));
                }
                this.monitor.quietAwait(this.cd);
            }
            finally {
                this.monitor.unlock();
            }
        }
        try {
            this.monitor.lock();
            int pos = this.all.getPos();
            this.all.chgPos(0);
            byte[] bb = this.all.read(size);
            byte[] after = this.all.read(pos - size);
            this.all.chgPos(0);
            this.all.append(after);
            byte[] byArray = bb;
            return byArray;
        }
        finally {
            this.monitor.unlock();
        }
    }

    public int readBeInt() throws SocketTimeoutException {
        MemoryBuffer mb = new MemoryBuffer(4);
        mb.append(this.read(4));
        mb.chgPos(0);
        return mb.readBeInt();
    }
}

