/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.utils;

import java.util.Collection;
import kr.floware.logging.Logger;
import kr.floware.utils.AssertException;
import kr.floware.utils.ErrorUtils;

public class Assert {
    private static Logger logger = Logger.getLogger();

    private static void loggingThrow(String format, Object ... args) {
        format = format.replaceAll("\\{\\}", "%s");
        String log = String.format(format, args);
        logger.d(log);
        throw new AssertException(log);
    }

    public static void fail(Throwable e) {
        Assert.fail(ErrorUtils.getErrorStack(e), new Object[0]);
    }

    public static void fail(String format, Object ... args) {
        Assert.loggingThrow(format, args);
    }

    public static void notNull(Object object, String format, Object ... args) {
        if (object == null) {
            Assert.loggingThrow(format, args);
        }
    }

    public static void isNull(Object object, String format, Object ... args) {
        if (object != null) {
            Assert.loggingThrow(format, args);
        }
    }

    public static void notEmpty(Collection<?> collection, String format, Object ... args) {
        Assert.notNull(collection, "collection is null", new Object[0]);
        if (collection.size() < 1) {
            Assert.loggingThrow(format, args);
        }
    }

    public static void isTrue(boolean expression, String format, Object ... args) {
        if (!expression) {
            Assert.loggingThrow(format, args);
        }
    }

    public static void areEqual(Object objA, Object objB, String format, Object ... args) {
        boolean bl = objA.equals(objB);
        Assert.isTrue(bl, format, args);
    }

    public static void areNotEqual(Object objA, Object objB, String format, Object ... args) {
        boolean bl = objA.equals(objB);
        Assert.isFalse(bl, format, args);
    }

    public static void isFalse(boolean expression, String format, Object ... args) {
        if (expression) {
            Assert.loggingThrow(format, args);
        }
    }
}

