/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Date;
import kr.floware.utils.Assert;
import kr.floware.utils.ConstUtils;

public class FileUtils {
    static final int BUFFER_SIZE = 4096;

    public static String getLaunchDirectory() {
        return new File("").getAbsolutePath();
    }

    public static File[] getFilesWithExtName(String directory, String ext) {
        File path = new File(directory);
        Assert.isTrue(path.exists(), "%s is not exist", directory);
        Assert.isTrue(path.isDirectory(), "%s is not directory", directory);
        final String finalExt = !ext.startsWith(".") ? "." + ext : ext;
        File[] files = path.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(finalExt);
            }
        });
        return files;
    }

    public static String getExtension(String path) {
        int i = path.lastIndexOf(".");
        return i > 0 ? path.substring(i + 1) : "";
    }

    public static String getFilePathWithoutExt(String path) {
        int i = path.lastIndexOf(".");
        return i > 0 ? path.substring(0, i) : path;
    }

    public static String getFileNameWithoutExt(String path) {
        File f = new File(path);
        String name = f.getName();
        int i = name.lastIndexOf(".");
        return i > 0 ? name.substring(0, i) : name;
    }

    public static String[] getFilesFromDirectory(String dir) {
        if (!dir.endsWith(File.separator)) {
            dir = dir + File.separator;
        }
        File file = new File(dir);
        File[] files = file.listFiles();
        String[] rets = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            File file2 = files[i];
            rets[i] = dir + file2.getName();
        }
        return rets;
    }

    public static Date getLastModifiedTime(String path) {
        File file = new File(path);
        Assert.isTrue(FileUtils.isExist(path), "%s not exist", path);
        long l = file.lastModified();
        return new Date(l);
    }

    public static File[] getFiles(String directory) {
        File file;
        File[] files;
        if (directory.trim().length() < 1) {
            return new File[0];
        }
        if (!directory.endsWith(File.separator)) {
            directory = directory + File.separator;
        }
        return null == (files = (file = new File(directory)).listFiles()) ? new File[]{} : files;
    }

    public static String getAbsoluteFile(String classpathFile) throws IOException {
        URL url = Thread.currentThread().getContextClassLoader().getResource(classpathFile);
        if (url == null) {
            throw new FileNotFoundException(classpathFile + " is not exist in classpath directory");
        }
        return url.getFile().replaceAll("%5c", "/");
    }

    public static boolean delete(String fileOrDir) {
        return new File(fileOrDir).delete();
    }

    public static boolean delete(File file) {
        return file.delete();
    }

    public static InputStream getInputStream(String fileName) throws IOException {
        Assert.isTrue(new File(fileName).exists(), "%s not exist", fileName);
        return new FileInputStream(fileName);
    }

    public static InputStream getInputStream(File file) throws IOException {
        return new FileInputStream(file);
    }

    public static OutputStream getOutputStream(String filename) throws IOException {
        return new FileOutputStream(filename);
    }

    public static long length(String filename) {
        return new File(filename).length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytes(File file) throws IOException {
        try (InputStream is = null;){
            is = FileUtils.getInputStream(file);
            byte[] buf = new byte[(int)file.length()];
            is.read(buf);
            byte[] byArray = buf;
            return byArray;
        }
    }

    public static byte[] getBytes(String filename) throws IOException {
        return FileUtils.getBytes(new File(filename));
    }

    public static byte[] getBytes(InputStream is, long size) throws IOException {
        byte[] buf = new byte[(int)size];
        is.read(buf);
        return buf;
    }

    public static String getName(String path) {
        return new File(path).getName();
    }

    public static String getAscii(String filename) throws IOException {
        return new String(FileUtils.getBytes(filename));
    }

    public static String getAscii(File file) throws IOException {
        return new String(FileUtils.getBytes(file));
    }

    public static String getAscii(String filename, String charsetName) throws Exception {
        return new String(FileUtils.getBytes(filename), charsetName);
    }

    public static boolean mkdirs(String dir) {
        File file = new File(dir);
        return file.exists() ? true : file.mkdirs();
    }

    public static synchronized void save(String filename, String data) throws IOException {
        FileUtils.save(filename, data, false);
    }

    public static synchronized void save(String filename, String data, boolean appendMode) throws IOException {
        Writer writer = null;
        try {
            FileUtils.mkdirs(FileUtils.getDirectoryFromFileName(filename));
            writer = new FileWriter(filename, appendMode);
            writer.write(data);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            writer.flush();
            writer.close();
        }
    }

    public static String getDirectoryFromFileName(String filename) {
        filename = filename.replace('/', ConstUtils.DIRCHAR);
        int idx = (filename = filename.replace('\\', ConstUtils.DIRCHAR)).lastIndexOf(ConstUtils.DIR);
        return idx > 0 ? filename.substring(0, idx) : "";
    }

    public static boolean isExist(String path) {
        return FileUtils.isExist(new File(path));
    }

    public static boolean isExist(File file) {
        return file.exists();
    }

    public static int copy(File in, File out) throws IOException {
        return FileUtils.copy(new BufferedInputStream(new FileInputStream(in)), (OutputStream)new BufferedOutputStream(new FileOutputStream(out)));
    }

    public static void copy(byte[] in, File out) throws IOException {
        ByteArrayInputStream inStream = new ByteArrayInputStream(in);
        BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(out));
        FileUtils.copy(inStream, (OutputStream)outStream);
    }

    public static byte[] copyToByteArray(File in) throws IOException {
        return FileUtils.copyToByteArray(new BufferedInputStream(new FileInputStream(in)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(InputStream in, OutputStream out) throws IOException {
        try {
            int byteCount = 0;
            byte[] buffer = new byte[4096];
            int bytesRead = -1;
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
                byteCount += bytesRead;
            }
            out.flush();
            int n = byteCount;
            return n;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void copy(byte[] in, OutputStream out) throws IOException {
        try {
            out.write(in);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static byte[] copyToByteArray(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        FileUtils.copy(in, (OutputStream)out);
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(Reader in, Writer out) throws IOException {
        try {
            int byteCount = 0;
            char[] buffer = new char[4096];
            int bytesRead = -1;
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
                byteCount += bytesRead;
            }
            out.flush();
            int n = byteCount;
            return n;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void copy(String in, Writer out) throws IOException {
        try {
            out.write(in);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static String copyToString(Reader in) throws IOException {
        StringWriter out = new StringWriter();
        FileUtils.copy(in, (Writer)out);
        return out.toString();
    }
}

