/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.utils;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.List;
import kr.floware.utils.Assert;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.transform.XSLTransformException;
import org.jdom.transform.XSLTransformer;
import org.jdom.xpath.XPath;

public class JdomUtils {
    public static String getQName(Attribute attribute) {
        String[] splits = attribute.getValue().split(":");
        if (splits.length == 1) {
            return attribute.getValue();
        }
        String prefix = splits[0];
        String postfix = splits[1];
        List list = attribute.getDocument().getRootElement().getAdditionalNamespaces();
        for (Namespace element : list) {
            if (!element.getPrefix().equals(prefix)) continue;
            return "{" + element.getURI() + "}:" + postfix;
        }
        return attribute.getValue();
    }

    public static Document loadText(String text) throws JDOMException, IOException {
        return new SAXBuilder().build((Reader)new StringReader(text));
    }

    public static Document quietLoadText(String text) {
        try {
            return JdomUtils.loadText(text);
        }
        catch (Exception e) {
            Assert.fail(e);
            return new Document();
        }
    }

    public static Document loadStream(InputStream stream) throws JDOMException, IOException {
        return new SAXBuilder().build(stream);
    }

    public static Document loadFile(String filename) throws JDOMException, IOException {
        return new SAXBuilder().build(new File(filename));
    }

    public static Document quietLoadFile(String fileName) {
        try {
            return JdomUtils.loadFile(fileName);
        }
        catch (Exception e) {
            Assert.fail(e);
            return new Document();
        }
    }

    public static Document xsltTransform(Document xsl, Document before) throws XSLTransformException {
        XSLTransformer transformer = new XSLTransformer(xsl);
        return transformer.transform(before);
    }

    public static Document xsltDefaultDocument(Document xsl) throws XSLTransformException {
        XSLTransformer transformer = new XSLTransformer(xsl);
        return transformer.transform(JdomUtils.createDocument("xml"));
    }

    public static XMLOutputter getOutputter(Format format) {
        return new XMLOutputter(format);
    }

    public static XMLOutputter getOutputter(boolean whitespace, boolean applyIndent, String indent) {
        return JdomUtils.getOutputter(whitespace, applyIndent, indent, null);
    }

    public static XMLOutputter getOutputter(boolean whitespace, boolean applyIndent, String indent, String encoding) {
        return JdomUtils.getOutputter(whitespace, applyIndent, indent, null, encoding);
    }

    public static XMLOutputter getOutputter(boolean whitespace, boolean applyIndent, String indent, String lineSeparator, String encoding) {
        Format format = JdomUtils.getFormat(whitespace);
        format.setExpandEmptyElements(true);
        if (encoding != null) {
            format.setEncoding(encoding);
        }
        if (applyIndent) {
            format.setIndent(indent);
        }
        if (lineSeparator != null) {
            format.setLineSeparator(lineSeparator);
        }
        return JdomUtils.getOutputter(format);
    }

    private static Format getFormat(boolean persistWhitespace) {
        return persistWhitespace ? Format.getRawFormat() : Format.getCompactFormat();
    }

    public static void getOutputStream(Object any, XMLOutputter outputter, OutputStream os) throws IOException {
        if (any instanceof Document) {
            outputter.output((Document)any, os);
        } else if (any instanceof Element) {
            outputter.output((Element)any, os);
        } else if (any instanceof CDATA) {
            outputter.output((CDATA)any, os);
        } else if (any instanceof Comment) {
            outputter.output((Comment)any, os);
        } else if (any instanceof List) {
            outputter.output((List)any, os);
        } else {
            Assert.fail("Unknown type", new Object[0]);
        }
    }

    public static void saveFile(Object any, String file, XMLOutputter outputter) throws IOException {
        FileWriter writer = new FileWriter(new File(file));
        if (any instanceof Document) {
            outputter.output((Document)any, (Writer)writer);
        } else if (any instanceof Element) {
            outputter.output((Element)any, (Writer)writer);
        } else if (any instanceof CDATA) {
            outputter.output((CDATA)any, (Writer)writer);
        } else if (any instanceof Comment) {
            outputter.output((Comment)any, (Writer)writer);
        } else if (any instanceof List) {
            outputter.output((List)any, (Writer)writer);
        } else {
            Assert.fail("Unknown type", new Object[0]);
        }
        ((Writer)writer).flush();
        ((Writer)writer).close();
    }

    public static void saveFile(Object any, String file) throws IOException {
        XMLOutputter outputter = JdomUtils.getOutputter(false, true, "    ");
        JdomUtils.saveFile(any, file, outputter);
    }

    public static String toString(Object any) {
        XMLOutputter outputter = JdomUtils.getOutputter(false, true, "    ");
        return JdomUtils.toString(any, outputter);
    }

    public static String toStringIndentless(Object any) {
        return JdomUtils.toStringIndentless(any, false);
    }

    public static String toStringIndentless(Object any, boolean persistWhitespace) {
        XMLOutputter out = JdomUtils.getOutputter(persistWhitespace, false, "    ");
        return JdomUtils.toString(any, out);
    }

    private static String toString(Object any, XMLOutputter out) {
        if (any instanceof Document) {
            return out.outputString((Document)any);
        }
        if (any instanceof Element) {
            return out.outputString((Element)any);
        }
        if (any instanceof CDATA) {
            return out.outputString((CDATA)any);
        }
        if (any instanceof Comment) {
            return out.outputString((Comment)any);
        }
        if (any instanceof List) {
            return out.outputString((List)any);
        }
        Assert.fail("Unknown type", new Object[0]);
        return "";
    }

    public static Document createDocument(String root) {
        return new Document(new Element(root));
    }

    public static Element createCDATA(Element element, String cdata) {
        return element.addContent((Content)new CDATA(cdata));
    }

    public static Document createDocument(Element root) {
        return new Document(root);
    }

    public static Element createElement(String name, String prefix, String namespace) {
        return new Element(name, Namespace.getNamespace((String)prefix, (String)namespace));
    }

    public static Element createElement(String name, Namespace namespace) {
        return new Element(name, namespace);
    }

    public static Element createElement(String name) {
        return new Element(name);
    }

    public static String getChildValue(Element element, int index) {
        List list = element.getChildren();
        return ((Element)list.get(index)).getText();
    }

    public static List<Element> getXPathList(Object any, String xpath) throws JDOMException {
        return XPath.selectNodes((Object)any, (String)xpath);
    }

    public static Element getXPathNode(Document doc, String xpath) throws JDOMException {
        return (Element)XPath.selectSingleNode((Object)doc, (String)xpath);
    }

    public static Element getQuietXPathNode(Document doc, String xpath) {
        try {
            return JdomUtils.getXPathNode(doc, xpath);
        }
        catch (Exception e) {
            Assert.fail(e);
            return new Element(e.toString());
        }
    }

    public static Element appendChildElement(Element to, Element from) {
        return to.addContent((Content)from);
    }

    public static Element appendAttr(Element to, String name, String value, String namespace) {
        return to.setAttribute(name, value, Namespace.getNamespace((String)namespace));
    }

    public static Element appendAttr(Element to, String name, String value, Namespace namespace) {
        return to.setAttribute(name, value, namespace);
    }

    public static Element appendAttr(Element to, String name, String value) {
        return to.setAttribute(name, value);
    }

    public static Element appendAttr(Element to, Attribute attr) {
        return to.setAttribute(attr);
    }

    public static Attribute createAttr(String name, String value) {
        return new Attribute(name, value);
    }

    public static Attribute createAttr(String name, String value, Namespace namespace) {
        return new Attribute(name, value, namespace);
    }

    public static void addNamespaceDeclaration(Element element, String prefix, String uri) {
        Namespace namespace = Namespace.getNamespace((String)prefix, (String)uri);
        element.addNamespaceDeclaration(namespace);
    }

    public static String getElementText(Document doc, String xpath) {
        Element e = JdomUtils.getQuietXPathNode(doc, xpath);
        return e.getTextTrim();
    }

    public static void setElementText(Document doc, String xpath, String v) {
        Element e = JdomUtils.getQuietXPathNode(doc, xpath);
        e.setText(v);
    }
}

