/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.utils;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import kr.floware.concurrent.FixedList;

public class LamUtils {
    public static <T> List<T> reverse(List<T> org) {
        CopyOnWriteArrayList<T> cp = new CopyOnWriteArrayList<T>(org);
        Collections.reverse(cp);
        return cp;
    }

    public static <T> CopyOnWriteArrayList<T> newList() {
        return new CopyOnWriteArrayList();
    }

    public static <K, V> Map<K, V> newMap() {
        return new ConcurrentHashMap();
    }

    public static <T> Set<T> newSet() {
        return new CopyOnWriteArraySet();
    }

    public static <T> List<T> newFixedList(int size) {
        return new FixedList(size);
    }

    public static <K, V> ConcurrentHashMap<K, V> newMap(int capa) {
        return new ConcurrentHashMap(capa);
    }

    public static <T> T first(List<T> ll) {
        return ll.get(0);
    }

    public static <T> List<T> firstNot(List<T> ll) {
        CopyOnWriteArrayList<T> a = new CopyOnWriteArrayList<T>(ll);
        a.remove(0);
        return a;
    }

    public static <T> T last(List<T> ll) {
        return ll.get(ll.size() - 1);
    }

    public static <T> List<T> lastNot(List<T> ll) {
        CopyOnWriteArrayList<T> a = new CopyOnWriteArrayList<T>(ll);
        a.remove(ll.size() - 1);
        return a;
    }
}

