/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.utils;

import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import kr.floware.logging.Logger;
import kr.floware.utils.StringUtils;
import org.apache.mina.core.buffer.IoBuffer;

public class MinaBuffer {
    private static Logger logger = Logger.getLogger();
    private IoBuffer bb;

    public void setByteOrder(ByteOrder byteOrder) {
        this.bb.order(byteOrder);
    }

    public ByteOrder getByteOrder() {
        return this.bb.order();
    }

    public MinaBuffer() {
        this(1024);
    }

    public void appendShort(int i) {
        this.bb.putShort((short)i);
    }

    public void appendLeUshort(int i) {
        this.bb.putUnsignedShort(i);
    }

    public int readShort() {
        return this.bb.getShort();
    }

    public MinaBuffer(int capa) {
        this.bb = IoBuffer.allocate((int)capa);
        this.bb.setAutoExpand(true);
        this.bb.order(ByteOrder.BIG_ENDIAN);
    }

    public void append(byte ... bs) {
        this.append(bs, 0, bs.length);
    }

    public void appendInt(int i) {
        this.bb.putInt(i);
    }

    public void appendLong(long l) {
        this.bb.putLong(l);
    }

    public void appendAscii(int length, String s) {
        byte[] bs = new byte[length];
        for (int i = 0; i < bs.length; ++i) {
            bs[i] = 32;
        }
        byte[] bs1 = s.getBytes();
        int min = Math.min(bs1.length, length);
        System.arraycopy(bs1, 0, bs, 0, min);
        this.append(bs, 0, length);
    }

    public void appendAscii(int length, String s, String charsetName) {
        byte[] bs = new byte[length];
        for (int i = 0; i < bs.length; ++i) {
            bs[i] = 32;
        }
        try {
            byte[] bs1 = s.getBytes(charsetName);
            int min = Math.min(bs1.length, length);
            System.arraycopy(bs1, 0, bs, 0, min);
        }
        catch (UnsupportedEncodingException e) {
            logger.e(e);
        }
        this.append(bs, 0, length);
    }

    public void append(byte[] bs, int offset, int length) {
        this.bb.put(bs, offset, length);
    }

    public int getPos() {
        return this.bb.position();
    }

    public byte[] read(int size) {
        byte[] bs = new byte[size];
        this.bb.get(bs);
        return bs;
    }

    public void changePos(int pos) {
        this.bb.position(pos);
    }

    public int readInt() {
        return this.bb.getInt();
    }

    public long readLong() {
        return this.bb.getLong();
    }

    public String readAscii(int size) {
        return this.readAscii(size, Charset.defaultCharset().toString());
    }

    public String readAscii(int size, String charsetName) {
        byte[] bs = this.read(size);
        for (int i = 0; i < bs.length; ++i) {
            if (bs[i] != 0) continue;
            bs[i] = 32;
        }
        try {
            return new String(bs, charsetName);
        }
        catch (UnsupportedEncodingException e) {
            return new String(bs);
        }
    }

    public void zeroPos() {
        this.bb.rewind();
    }

    public void clear() {
        this.bb.sweep();
    }

    public synchronized byte[] toBytes() {
        byte[] bs = new byte[this.length()];
        this.bb.getSlice(0, bs.length).get(bs);
        return bs;
    }

    public String toHex() {
        return StringUtils.toHex2String(this.toBytes());
    }

    public int length() {
        return this.getPos();
    }
}

