/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import kr.floware.utils.Assert;
import kr.floware.utils.StreamUtils;

public abstract class SznUtils {
    public static Object clone(Serializable serializable) {
        return SznUtils.deserialize(SznUtils.serialize(serializable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serialize(Serializable serializable, OutputStream outputStream) {
        Assert.notNull(outputStream, "outputStream is null", new Object[0]);
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(outputStream);
            out.writeObject(serializable);
        }
        catch (Exception e) {
            try {
                Assert.fail(e);
            }
            catch (Throwable throwable) {
                StreamUtils.quietClose(out);
                throw throwable;
            }
            StreamUtils.quietClose(out);
        }
        StreamUtils.quietClose(out);
    }

    public static byte[] serialize(Serializable serializable) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        SznUtils.serialize(serializable, baos);
        return baos.toByteArray();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object deserialize(InputStream inputStream) {
        Object object;
        Assert.notNull(inputStream, "inputStream is null", new Object[0]);
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(inputStream);
            object = in.readObject();
        }
        catch (Exception e) {
            try {
                Assert.fail(e);
            }
            catch (Throwable throwable) {
                StreamUtils.quietClose(in);
                throw throwable;
            }
            StreamUtils.quietClose(in);
            return new Object();
        }
        StreamUtils.quietClose(in);
        return object;
    }

    public static Object deserialize(byte[] bs) {
        Assert.isTrue(bs.length > 0, "deserialize byte length 0", new Object[0]);
        Assert.notNull(bs, "deserialize object is null", new Object[0]);
        ByteArrayInputStream is = new ByteArrayInputStream(bs);
        return SznUtils.deserialize(is);
    }
}

