/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.utils;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Base64;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class ZipUtils {
    private static final byte GZIP_MAGIC_BYTE_1 = 31;
    private static final byte GZIP_MAGIC_BYTE_2 = -117;

    private static boolean isGzipped(byte[] data) {
        return data.length > 2 && data[0] == 31 && data[1] == -117;
    }

    public static byte[] gzip(byte ... org) {
        if (ZipUtils.isGzipped(org)) {
            return org;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream(byteArrayOutputStream);){
                gzipOutputStream.write(org);
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] ungzip(byte ... compressed) {
        if (!ZipUtils.isGzipped(compressed)) {
            return compressed;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(compressed);
            try (GZIPInputStream gzipInputStream = new GZIPInputStream(byteArrayInputStream);){
                int len;
                byte[] buffer = new byte[4096];
                while ((len = gzipInputStream.read(buffer)) != -1) {
                    byteArrayOutputStream.write(buffer, 0, len);
                }
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String gzip(String data) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(data.length());
            GZIPOutputStream gzip = new GZIPOutputStream(bos);
            gzip.write(data.getBytes("utf-8"));
            gzip.close();
            byte[] compressed = bos.toByteArray();
            bos.close();
            return Base64.getEncoder().encodeToString(compressed);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String ungzip(String source) {
        try {
            String line;
            byte[] compressed = Base64.getDecoder().decode(source);
            ByteArrayInputStream bis = new ByteArrayInputStream(compressed);
            GZIPInputStream gis = new GZIPInputStream(bis);
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)gis, "UTF-8"));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            br.close();
            gis.close();
            bis.close();
            return sb.toString();
        }
        catch (Exception e) {
            return "";
        }
    }
}

