/*
 * Decompiled with CFR 0.152.
 */
package kr.floware;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public interface Linq {
    public static final Linq instance = new Linq(){};

    public static Linq getInstance() {
        return instance;
    }

    default public <T> Collector<T, ?, List<T>> toList() {
        return Collectors.toCollection(CopyOnWriteArrayList::new);
    }

    default public <K, T> Collector<? super T, ?, ?> toMap(Function<? super T, ? extends K> key) {
        return Collectors.toConcurrentMap(key, x -> x);
    }

    default public <K, T extends Comparable<? super T>> Comparator<K> orderAsc(Function<? super K, ? extends T> key) {
        return Comparator.comparing(key);
    }

    default public <K, T extends Comparable<? super T>> Comparator<? super K> orderDesc(Function<? super K, ? extends T> key) {
        return Comparator.comparing(key).reversed();
    }

    default public <T, K> Collector<T, ?, Map<K, List<T>>> groupList(Function<? super T, ? extends K> key) {
        return Collectors.groupingBy(key);
    }
}

