/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class Lockable {
    private ReentrantLock lock = new ReentrantLock();
    private Condition condition = this.lock.newCondition();

    public void signalAll() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.condition.signalAll();
        }
        finally {
            lock.unlock();
        }
    }

    public void signal() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.condition.signal();
        }
        finally {
            lock.unlock();
        }
    }

    public boolean quietAwait() {
        return this.quietAwait(Long.MAX_VALUE);
    }

    public boolean quietAwait(long timeout) {
        try {
            return this.await(timeout);
        }
        catch (InterruptedException e) {
            this.signal();
            return true;
        }
    }

    public boolean await() throws InterruptedException {
        return this.await(Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean await(long timeout) throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            boolean bl = this.condition.await(timeout, TimeUnit.MILLISECONDS);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }
}

