/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.fmq;

import java.util.HashMap;
import java.util.Map;

public enum MsgKind {
    UNKNOWN(-1),
    DATA(0),
    REQUEST(10),
    REPLY(12),
    REMOVE_REQ(13),
    LEARNING(20),
    HEART_BEAT(21),
    HEART_BEAT_REP(22),
    COMM_STATE_TRUE(23),
    COMM_STATE_FALSE(24),
    ACTIVE_STATE_TRUE(31),
    ACTIVE_STATE_FALSE(32);

    private final byte code;
    private static final Map<Byte, MsgKind> lookupMap;

    private MsgKind(byte code) {
        this.code = code;
    }

    public byte toByte() {
        return this.code;
    }

    public static MsgKind fromByte(byte b) {
        return lookupMap.getOrDefault(b, UNKNOWN);
    }

    public boolean isLearn() {
        return this == LEARNING;
    }

    public boolean isHbeatReq() {
        return this == HEART_BEAT;
    }

    public boolean isActiveState() {
        return this == ACTIVE_STATE_FALSE || this == ACTIVE_STATE_TRUE;
    }

    public boolean isActiveTrue() {
        return this == ACTIVE_STATE_TRUE;
    }

    public boolean isCommTrue() {
        return this == COMM_STATE_TRUE;
    }

    public boolean isDataReqRep() {
        return this == DATA || this == REQUEST || this == REPLY;
    }

    static {
        lookupMap = new HashMap<Byte, MsgKind>();
        for (MsgKind kind : MsgKind.values()) {
            lookupMap.put(kind.toByte(), kind);
        }
    }
}

