/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.hsms.format;

import java.io.UnsupportedEncodingException;
import kr.floware.hsms.format.AbstractFormat;
import kr.floware.utils.Assert;
import kr.floware.utils.MemoryBuffer;
import kr.floware.utils.StringUtils;

public class AsciiFormat
extends AbstractFormat {
    public static final int TYPE = 64;

    public AsciiFormat() {
    }

    public AsciiFormat(String value) {
        this("", value);
    }

    public AsciiFormat(String name, String value) {
        this.setName(name);
        this.setLength(value.length());
        this.setValue(value);
    }

    @Override
    public int getType() {
        return 64;
    }

    @Override
    public String getLogType() {
        return "A";
    }

    @Override
    protected byte[] encodeOneValue(String v) {
        Assert.fail("not implement ascii format", new Object[0]);
        return null;
    }

    @Override
    public void encode(MemoryBuffer mb) {
        String v = this.getValue();
        if (this.isFixedLength()) {
            v = StringUtils.rightPad(v, this.getLength());
        }
        if (!this.hasAlias()) {
            this.setValue(v);
        }
        byte[] bs = new byte[]{};
        try {
            bs = this.getValue().getBytes("ks_c_5601-1987");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (!this.isFixedLength()) {
            this.setLength(bs.length);
        }
        mb.append(this.getEncodeAddedLengthType());
        mb.append(this.getEncodeFormatLength());
        mb.append(bs, 0, this.getLength());
    }

    private String bs2Korean(byte[] bs) {
        try {
            return new String(bs, "ks_c_5601-1987");
        }
        catch (UnsupportedEncodingException e) {
            return new String(bs);
        }
    }

    @Override
    public int valueCopy(byte[] bs, int pos) {
        byte[] bs2 = new byte[this.getLength()];
        System.arraycopy(bs, pos, bs2, 0, this.getLength());
        this.setValue(this.bs2Korean(bs2));
        return pos += this.getLength();
    }

    @Override
    public boolean isAsciiFormat() {
        return true;
    }
}

