/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.hsms.format;

import kr.floware.hsms.format.AbstractFormat;
import kr.floware.hsms.format.BytesConverter;
import kr.floware.utils.Assert;
import kr.floware.utils.MemoryBuffer;
import kr.floware.utils.NumUtils;
import kr.floware.utils.StringUtils;

public class BinaryFormat
extends AbstractFormat {
    public static final int TYPE = 32;
    public static boolean LOG_HEX_MODE;
    private byte[] arrays = new byte[0];

    public BinaryFormat() {
    }

    public BinaryFormat(int value) {
        Assert.isTrue(NumUtils.rangeCheck(value, 0, 255), "Binary Format Support 0~255", new Object[0]);
        this.setLength(1);
        this.setValue(String.valueOf(value));
    }

    @Override
    public int getType() {
        return 32;
    }

    @Override
    public String getLogType() {
        return "B";
    }

    @Override
    protected byte[] encodeOneValue(String iter) {
        int v = Integer.parseInt(iter);
        Assert.isTrue(v > -1, "%s's binary value >= 0", this.getName());
        Assert.isTrue(v < 256, "%s's binary value <= 255", this.getName());
        return new byte[]{(byte)v};
    }

    @Override
    public void encode(MemoryBuffer mb_all) {
        if (this.getArrays().length < 1) {
            super.encode(mb_all);
            return;
        }
        mb_all.append(this.getEncodeAddedLengthType());
        mb_all.append(this.getEncodeFormatLength());
        mb_all.append(this.getArrays());
        this.setValue(StringUtils.toDec2String(this.getArrays()).trim());
    }

    private final String byte2Binary(byte[] bs) {
        switch (bs.length) {
            case 0: {
                return "";
            }
            case 1: {
                return BytesConverter.byte2ByteString(bs[0]);
            }
        }
        StringBuffer sb = new StringBuffer(bs.length * 3);
        for (int i = 0; i < bs.length; ++i) {
            sb.append(StringUtils.toDec2String(bs[i]));
        }
        return sb.toString().trim();
    }

    @Override
    public byte[] getArrays() {
        return this.arrays;
    }

    @Override
    public void setArrays(byte[] arrays) {
        this.arrays = arrays;
        this.setLength(this.getArrays().length);
    }

    @Override
    public int valueCopy(byte[] bs, int pos) {
        byte[] bs2 = new byte[this.getLength()];
        System.arraycopy(bs, pos, bs2, 0, this.getLength());
        this.setArrays(bs2);
        this.setValue(this.byte2Binary(bs2));
        return pos += this.getLength();
    }

    @Override
    public String treeString() {
        String aliasV;
        if (!LOG_HEX_MODE || this.getArrays().length < 1) {
            return super.treeString();
        }
        String name = this.getFullName() == null || this.getFullName().equals("") ? "" : this.getFullName() + " ";
        String orgV = this.getOriginValue();
        String fixed = this.isFixedLength() ? "" : "V";
        String string = aliasV = this.aliasValues.size() > 0 ? String.format(" [*%s]", this.getAliasValue()) : "";
        if (orgV.equals(this.getValue())) {
            orgV = StringUtils.toHex2String(this.getArrays()).trim();
        }
        return String.format("%s %s%s %s'%s'%s", this.getLogType(), this.getLength(), fixed, name, orgV, aliasV);
    }
}

