/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.hsms.format;

import kr.floware.hsms.format.AbstractFormat;
import kr.floware.hsms.format.BytesConverter;

public class BooleanFormat
extends AbstractFormat {
    public static final int TYPE = 36;

    public BooleanFormat() {
    }

    public BooleanFormat(boolean value) {
        this("", value);
    }

    public BooleanFormat(String name, boolean value) {
        this.setName(name);
        this.setLength(1);
        this.setValue(value ? "1" : "0");
    }

    @Override
    public int getType() {
        return 36;
    }

    @Override
    public String getLogType() {
        return "BOOLEAN";
    }

    @Override
    protected byte[] encodeOneValue(String iter) {
        if (iter.toLowerCase().equals("true")) {
            iter = "1";
        }
        if (iter.toLowerCase().equals("false")) {
            iter = "0";
        }
        return new byte[]{(byte)Integer.parseInt(iter)};
    }

    @Override
    public int valueCopy(byte[] bs, int pos) {
        byte[] bs2 = new byte[this.getLength()];
        System.arraycopy(bs, pos, bs2, 0, this.getLength());
        this.setValue(BytesConverter.byte2Int1(bs2));
        return pos += this.getLength();
    }
}

