/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.hsms.format;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import kr.floware.utils.StreamUtils;

class BytesConverter {
    static final String SPACE = " ";

    BytesConverter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final long byte2Long(byte[] a8Byte) {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(a8Byte));
        try {
            long l = dis.readLong();
            return l;
        }
        catch (Exception e) {
            long l = 0L;
            return l;
        }
        finally {
            StreamUtils.quietClose(dis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String byte2ReadUShortString(byte[] bs2) {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bs2));
        try {
            String string = String.valueOf(dis.readUnsignedShort());
            return string;
        }
        catch (Exception e) {
            String string = "0";
            return string;
        }
        finally {
            StreamUtils.quietClose(dis);
        }
    }

    private static final String byte2IntString(byte b1) {
        int a = b1 & 0xFF;
        return a >= 128 ? String.valueOf(a - 255 - 1) : String.valueOf(a);
    }

    public static final String byte2ByteString(byte b1) {
        return String.valueOf(b1 & 0xFF);
    }

    public static final String byte2Uint1(byte[] bs1) {
        switch (bs1.length) {
            case 0: {
                return "";
            }
            case 1: {
                return BytesConverter.byte2ByteString(bs1[0]);
            }
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < bs1.length; ++i) {
            sb.append(BytesConverter.byte2ByteString(bs1[i]) + SPACE);
        }
        return sb.toString().trim();
    }

    public static final String byte2Uint2(byte[] bs2) {
        switch (bs2.length) {
            case 0: {
                return "";
            }
            case 2: {
                return BytesConverter.byte2ReadUShortString(bs2);
            }
        }
        byte[] a = new byte[2];
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < bs2.length / 2; ++i) {
            System.arraycopy(bs2, i * 2, a, 0, 2);
            sb.append(BytesConverter.byte2ReadUShortString(a) + SPACE);
        }
        return sb.toString().trim();
    }

    public static String stringValue(long l) {
        return String.valueOf(l);
    }

    public static final String byte2Uint4(byte[] aBytes) {
        byte[] a = new byte[8];
        switch (aBytes.length) {
            case 0: {
                return "";
            }
            case 4: {
                System.arraycopy(aBytes, 0, a, 4, 4);
                return BytesConverter.stringValue(BytesConverter.byte2Long(a));
            }
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < aBytes.length / 4; ++i) {
            System.arraycopy(aBytes, i * 4, a, 4, 4);
            sb.append(BytesConverter.stringValue(BytesConverter.byte2Long(a)) + SPACE);
        }
        return sb.toString().trim();
    }

    public static final String byte2Uint8(byte[] aBytes) {
        switch (aBytes.length) {
            case 0: {
                return "";
            }
            case 8: {
                return BytesConverter.stringValue(BytesConverter.byte2Long(aBytes));
            }
        }
        byte[] a = new byte[8];
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < aBytes.length / 8; ++i) {
            System.arraycopy(aBytes, i * 8, a, 0, 8);
            sb.append(BytesConverter.byte2Long(a));
            sb.append(SPACE);
        }
        return sb.toString().trim();
    }

    public static final String byte2Int1(byte[] aBytes) {
        switch (aBytes.length) {
            case 0: {
                return "";
            }
            case 1: {
                return BytesConverter.byte2IntString(aBytes[0]);
            }
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < aBytes.length; ++i) {
            sb.append(BytesConverter.byte2IntString(aBytes[i]) + SPACE);
        }
        return sb.toString().trim();
    }

    public static final String byte2Int2(byte[] aBytes) {
        switch (aBytes.length) {
            case 0: {
                return "";
            }
            case 2: {
                return String.valueOf(BytesConverter.byte2Short(aBytes));
            }
        }
        byte[] a = new byte[2];
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < aBytes.length / 2; ++i) {
            System.arraycopy(aBytes, i * 2, a, 0, 2);
            sb.append(BytesConverter.byte2Short(a) + SPACE);
        }
        return sb.toString().trim();
    }

    public static final String byte2Int4(byte[] aBytes) {
        switch (aBytes.length) {
            case 0: {
                return "";
            }
            case 1: {
                return String.valueOf(BytesConverter.byte2Int(aBytes));
            }
        }
        byte[] a = new byte[4];
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < aBytes.length / 4; ++i) {
            System.arraycopy(aBytes, i * 4, a, 0, 4);
            sb.append(BytesConverter.byte2Int(a) + SPACE);
        }
        return sb.toString().trim();
    }

    public static final String byte2Int8(byte[] aBytes) {
        return BytesConverter.byte2Uint8(aBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final short byte2Short(byte[] aBytes) {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(aBytes));
        try {
            short s = dis.readShort();
            return s;
        }
        catch (Exception e) {
            short s = 0;
            return s;
        }
        finally {
            StreamUtils.quietClose(dis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int byte2Int(byte[] aBytes) {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(aBytes));
        try {
            int n = dis.readInt();
            return n;
        }
        catch (Exception e) {
            int n = 0;
            return n;
        }
        finally {
            StreamUtils.quietClose(dis);
        }
    }
}

