/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.hsms.format;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import kr.floware.hsms.format.AbstractFormat;

public class Float8Format
extends AbstractFormat {
    public static final int TYPE = 128;

    @Override
    public int getType() {
        return 128;
    }

    @Override
    public String getLogType() {
        return "F8";
    }

    @Override
    protected int multiple() {
        return 8;
    }

    @Override
    protected byte[] encodeOneValue(String iter) {
        double d = Double.parseDouble(iter);
        return this.double2Byte(d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String byte2DoubleString(byte[] a8Bytes) {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(a8Bytes));
        try {
            String string = String.valueOf(dis.readDouble());
            return string;
        }
        catch (Exception e) {
            String string = "0";
            return string;
        }
        finally {
            this.close(dis);
        }
    }

    private final String byte2Float8(byte[] bs) {
        switch (bs.length) {
            case 0: {
                return "";
            }
            case 8: {
                return this.byte2DoubleString(bs);
            }
        }
        byte[] a = new byte[8];
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < bs.length / 8; ++i) {
            System.arraycopy(bs, i * 8, a, 0, 8);
            sb.append(this.byte2DoubleString(a) + " ");
        }
        return sb.toString().trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] double2Byte(double d) {
        ByteArrayOutputStream b = new ByteArrayOutputStream(8);
        try {
            DataOutputStream dos = new DataOutputStream(b);
            dos.writeDouble(d);
            dos.close();
            byte[] byArray = b.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            byte[] byArray = b.toByteArray();
            return byArray;
        }
        finally {
            this.close(b);
        }
    }

    @Override
    public int valueCopy(byte[] bs, int pos) {
        int length = this.getLength() * 8;
        byte[] bs2 = new byte[length];
        System.arraycopy(bs, pos, bs2, 0, length);
        this.setValue(this.byte2Float8(bs2));
        return pos += length;
    }
}

