/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.hsms.format;

import kr.floware.hsms.format.AbstractFormat;
import kr.floware.hsms.format.BytesConverter;
import kr.floware.hsms.format.ObjectConverter;
import kr.floware.utils.Assert;

public class Int2Format
extends AbstractFormat {
    public static final int TYPE = 104;

    public Int2Format() {
    }

    public Int2Format(int value) {
        if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
            Assert.fail("I2 Format Support -32768~32767", new Object[0]);
        }
        this.setLength(1);
        this.setValue(String.valueOf(value));
    }

    @Override
    public int getType() {
        return 104;
    }

    @Override
    public String getLogType() {
        return "I2";
    }

    @Override
    protected int multiple() {
        return 2;
    }

    @Override
    protected byte[] encodeOneValue(String iter) {
        int v = Integer.parseInt(iter);
        Assert.isTrue(v <= Short.MAX_VALUE, "%s range -32768~32767", this.getName());
        Assert.isTrue(v >= Short.MIN_VALUE, "%s range -32768~32767", this.getName());
        return ObjectConverter.short2Byte((short)v);
    }

    @Override
    public int valueCopy(byte[] bs, int pos) {
        int length = this.getLength() * 2;
        byte[] bs2 = new byte[length];
        System.arraycopy(bs, pos, bs2, 0, length);
        this.setValue(BytesConverter.byte2Int2(bs2));
        return pos += length;
    }
}

