/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.hsms.format;

import kr.floware.hsms.format.AbstractFormat;
import kr.floware.hsms.format.BytesConverter;
import kr.floware.hsms.format.ObjectConverter;
import kr.floware.utils.Assert;

public class Int4Format
extends AbstractFormat {
    public static final int TYPE = 112;

    public Int4Format() {
    }

    public Int4Format(int value) {
        if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
            Assert.fail("I4 Format Support -2147483648~2147483647", new Object[0]);
        }
        this.setLength(1);
        this.setValue(String.valueOf(value));
    }

    @Override
    public int getType() {
        return 112;
    }

    @Override
    public String getLogType() {
        return "I4";
    }

    @Override
    protected int multiple() {
        return 4;
    }

    @Override
    protected byte[] encodeOneValue(String iter) {
        int v = Integer.parseInt(iter);
        return ObjectConverter.int2Byte(v);
    }

    @Override
    public int valueCopy(byte[] bs, int pos) {
        int length = this.getLength() * 4;
        byte[] bs2 = new byte[length];
        System.arraycopy(bs, pos, bs2, 0, length);
        this.setValue(BytesConverter.byte2Int4(bs2));
        return pos += length;
    }
}

