/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.hsms.format;

import kr.floware.hsms.format.AbstractFormat;
import kr.floware.hsms.format.BytesConverter;
import kr.floware.hsms.format.ObjectConverter;

public class Int8Format
extends AbstractFormat {
    public static final int TYPE = 96;

    @Override
    public int getType() {
        return 96;
    }

    @Override
    public String getLogType() {
        return "I8";
    }

    @Override
    protected int multiple() {
        return 8;
    }

    @Override
    protected byte[] encodeOneValue(String iter) {
        long v = Long.parseLong(iter);
        return ObjectConverter.long2Byte(v);
    }

    @Override
    public int valueCopy(byte[] bs, int pos) {
        int length = this.getLength() * 8;
        byte[] bs2 = new byte[length];
        System.arraycopy(bs, pos, bs2, 0, length);
        this.setValue(BytesConverter.byte2Int8(bs2));
        return pos += length;
    }
}

