/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.hsms.format;

import java.util.ArrayList;
import java.util.List;
import kr.floware.hsms.format.AbstractFormat;
import kr.floware.hsms.format.Format;
import kr.floware.hsms.format.FormatVisitor;
import kr.floware.hsms.format.Formatter;
import kr.floware.utils.Assert;
import kr.floware.utils.MemoryBuffer;
import org.jdom.Element;

public class ListFormat
extends AbstractFormat {
    public static final int TYPE = 0;
    private List<Format> children = new ArrayList<Format>();

    public ListFormat() {
    }

    public ListFormat(int length) {
        this("", length);
    }

    public ListFormat(String name, int length) {
        this.setName(name);
        this.setLength(length);
    }

    @Override
    public boolean isStrictValue() {
        return false;
    }

    @Override
    public boolean isListFormat() {
        return true;
    }

    @Override
    public Object clone() {
        ListFormat clone = (ListFormat)super.clone();
        clone.setChildren(new ArrayList<Format>());
        for (Format child : this.getChildren()) {
            ((AbstractFormat)child).setMessage(clone.getMessage());
            clone.add((Format)child.clone());
            ((AbstractFormat)child).setMessage(this.getMessage());
        }
        return clone;
    }

    @Override
    public Format add(Format format) {
        super.add(format);
        if (this.getLength() > this.getChildren().size()) {
            format.setParent(this);
            this.getChildren().add(format);
        } else {
            this.getParent().add(format);
        }
        return format.isListFormat() ? format : this;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getLogType() {
        return "L";
    }

    @Override
    public String getValue() {
        return String.valueOf(this.getLength());
    }

    @Override
    public int getIntValue() {
        return this.getLength();
    }

    @Override
    public void setValue(String value) {
    }

    @Override
    int decoding(byte[] bs, int pos) {
        pos = super.decoding(bs, pos);
        return pos;
    }

    @Override
    public void encode(MemoryBuffer mb) {
        this.setFixedLength(true);
        mb.append(this.getEncodeAddedLengthType());
        mb.append(this.getEncodeFormatLength());
        for (Format format : this.getChildren()) {
            format.encode(mb);
        }
    }

    @Override
    protected byte[] encodeOneValue(String iter) {
        Assert.fail("not supported method", new Object[0]);
        return null;
    }

    @Override
    public List<Format> getChildren() {
        return this.children;
    }

    public void setChildren(List<Format> children) {
        this.children = children;
    }

    @Override
    public String treeString() {
        String name = this.getFullName() == null || this.getFullName().equals("") ? "" : " " + this.getFullName();
        String fixed = this.isFixedLength() ? "" : "V";
        return this.getLogType() + " " + this.getLength() + fixed + name;
    }

    @Override
    public String logFormat() {
        StringBuffer sb = new StringBuffer(256);
        sb.append(super.logFormat());
        for (Format format : this.getChildren()) {
            sb.append(format.logFormat());
        }
        return sb.toString();
    }

    @Override
    public void setIndex(int level) {
        super.setIndex(level);
        for (Format format : this.getChildren()) {
            format.setIndex(level + 1);
        }
    }

    @Override
    public Format fromLibrary(Element element) {
        super.fromLibrary(element);
        List children = element.getChildren();
        for (Element e : children) {
            Format format = Formatter.newInstance(e.getName());
            format.setMessage(this.getMessage());
            format.fromLibrary(e);
            this.add(format);
        }
        return this;
    }

    @Override
    public int valueCopy(byte[] bs, int pos) {
        return pos;
    }

    @Override
    public Format copyNames(Format require) {
        super.copyNames(require);
        if (!this.isFixedLength()) {
            this.duplicateChildren(require.getLength());
        }
        for (int i = 0; i < this.getChildren().size(); ++i) {
            this.getChild(i).copyNames(require.getChild(i));
        }
        return require;
    }

    @Override
    public void duplicateChildren(int size) {
        if (this.isFixedLength()) {
            Assert.fail("Fixed list %s can't duplicate", this.getName());
        }
        Format origin = (Format)this.getChild(0).clone();
        this.removeChildren();
        for (int i = 0; i < size; ++i) {
            this.add(((AbstractFormat)origin).clone2(i));
        }
        this.setFixedLength(true);
        this.setLength(size);
    }

    @Override
    protected Format clone2(int attach) {
        Format clone = super.clone2(attach);
        clone.getChildren().clear();
        for (int i = 0; i < this.getChildren().size(); ++i) {
            Format copy = ((AbstractFormat)this.getChild(i)).clone2(attach);
            clone.add(copy);
        }
        return clone;
    }

    @Override
    public boolean isWellKnown(Format checkIt) {
        if (!super.isWellKnown(checkIt)) {
            return false;
        }
        if (this.isFixedLength()) {
            if (this.getChildren().size() != checkIt.getChildren().size()) {
                this.setComment("xxxxx List Count Not Equal");
                return false;
            }
        } else {
            if (checkIt.getChildren().size() > super.getLength()) {
                this.setComment("xxxxx Too Long Child");
                return false;
            }
            this.duplicateChildren(checkIt.getChildren().size());
        }
        return new FormatVisitor().isWellKnown(this, checkIt);
    }
}

