/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.hsms.format;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kr.floware.hsms.format.AbstractFormat;
import kr.floware.hsms.format.AliasMessageName;
import kr.floware.hsms.format.BytesConverter;
import kr.floware.hsms.format.Format;
import kr.floware.hsms.format.FormatVisitor;
import kr.floware.hsms.format.Formatter;
import kr.floware.hsms.format.ObjectConverter;
import kr.floware.utils.Assert;
import kr.floware.utils.ConstUtils;
import kr.floware.utils.MemoryBuffer;
import kr.floware.utils.StringUtils;
import org.jdom.Document;
import org.jdom.Element;

public class SFMessage
extends AbstractFormat {
    private static String STREAM = "stream";
    private static String FUNCTION = "function";
    private static String WBIT = "wbit";
    private static String AUTOREPLY = "autoreply";
    private static String MSG_KIND = "msgkind";
    public static final int TYPE = 255;
    private String id;
    private String name;
    private boolean receive;
    private Object correlation;
    private byte[] header = new byte[10];
    private byte[] body = new byte[0];
    private boolean autoreply = false;
    private int unkCode;
    private int msgKind;
    private int reqTimeout;
    private byte[] checkSum = new byte[2];
    private List<Format> children = new ArrayList<Format>();
    private static final String SEND = "SEND ";
    private static final String RECD = "RECD ";
    private boolean hsms = true;
    private Map<String, Format> names = new ConcurrentHashMap<String, Format>();
    private AliasMessageName aliasMessageName = new AliasMessageName();
    private transient List<SFMessage> compList = null;

    @Override
    public Format idx(int ... idx) {
        return super.getByIndex(idx);
    }

    public void setCompList(List<SFMessage> compList) {
        this.compList = compList;
    }

    public List<SFMessage> getCompList() {
        return this.compList;
    }

    public Collection<String> getNames() {
        return this.names.keySet();
    }

    public String getSxFx() {
        return "S" + this.getStream() + "F" + this.getFunction();
    }

    public void addName(Format require) {
        if (require.getName().trim().equals("")) {
            return;
        }
        this.names.put(require.getFullName(), require);
    }

    @Override
    public void duplicateChildren(int count) {
        Assert.fail("ListFormat only supported method", new Object[0]);
    }

    public boolean hasFormatName(String name) {
        return this.names.containsKey(name);
    }

    public Format getByName(String name) {
        Assert.isTrue(this.names.containsKey(name), "Can't Found Name : " + name, new Object[0]);
        return this.names.get(name);
    }

    public Format f(String name) {
        return this.getByName(name);
    }

    public Format f(int ... name) {
        return this.idx(name);
    }

    @Override
    public Format copyNames(Format require) {
        require.setName(this.getName());
        new FormatVisitor().copyNames(this.children, require.getChildren());
        ((SFMessage)require).aliasMessageName = this.aliasMessageName;
        this.getName((SFMessage)require);
        return require;
    }

    public boolean isAbortMessage() {
        return 0 == this.getFunction();
    }

    public boolean isHsmsLinktestMessage() {
        return 5 == this.getStype() || 6 == this.getStype();
    }

    public boolean isHsmsLinkReqMessage() {
        return 5 == this.getStype();
    }

    public boolean isHsmsLinkRspMessage() {
        return 6 == this.getStype();
    }

    @Override
    public boolean isListFormat() {
        return true;
    }

    @Override
    public Object clone() {
        SFMessage clone = (SFMessage)super.clone();
        clone.setHeader(this.copyHeader());
        clone.setChildren(new ArrayList<Format>());
        clone.names = new ConcurrentHashMap<String, Format>();
        for (Format child : this.getChildren()) {
            child.setMessage(clone);
            clone.add((Format)child.clone());
            child.setMessage(this);
        }
        return clone;
    }

    @Override
    public SFMessage getMessage() {
        return this;
    }

    public String logFormatHex(String indent) {
        StringBuffer sb = new StringBuffer(this.getBody().length * 3);
        for (byte b : this.getHeader()) {
            sb.append(StringUtils.toHex2String(b));
        }
        sb.append(ConstUtils.NEWLINE + indent);
        int i = 1;
        for (byte b : this.getBody()) {
            sb.append(StringUtils.toHex2String(b));
            if (i % 20 == 0) {
                sb.append(ConstUtils.NEWLINE + indent);
            }
            ++i;
        }
        return sb.toString();
    }

    @Override
    public String getLogType() {
        return this.getName();
    }

    @Override
    public int getLength() {
        return this.header.length + this.body.length;
    }

    String toStringBody() {
        new FormatVisitor().setIndex(this.getChildren());
        return this.logFormatBody(2048, this.getChildren());
    }

    private String logFormatBody(int length, List<Format> formats) {
        StringBuffer sb = new StringBuffer(length * 10);
        for (Format format : formats) {
            sb.append(format.logFormat());
        }
        if (formats.size() > 0) {
            sb.delete(sb.length() - ConstUtils.NEWLINE.length(), sb.length());
        }
        return sb.toString();
    }

    public byte[] getLengthBytes() {
        return ObjectConverter.uint4ToByte(String.valueOf(this.getLength()));
    }

    public byte[] copyHeader() {
        byte[] bs = new byte[10];
        System.arraycopy(this.header, 0, bs, 0, 10);
        return bs;
    }

    public void setDeviceId(int deviceId) {
        byte[] a = ObjectConverter.short2Byte((short)deviceId);
        System.arraycopy(a, 0, this.header, 0, 2);
    }

    public int getDeviceId() {
        byte[] devid = new byte[2];
        System.arraycopy(this.header, 0, devid, 0, 2);
        devid[0] = (byte)(devid[0] & 0xF);
        return Integer.parseInt(BytesConverter.byte2Int2(devid));
    }

    public void setStream(int stream) {
        if (this.isWbit()) {
            stream += 128;
        }
        this.header[2] = (byte)stream;
    }

    public void setWbit(boolean wbit) {
        this.header[2] = wbit ? (byte)((this.header[2] & 0x7F) + 128) : (byte)(this.header[2] & 0x7F);
    }

    public int getStream() {
        int stream = this.header[2] & 0xFF;
        return this.isWbit() ? stream - 128 : stream;
    }

    public void setFunction(int function) {
        this.header[3] = (byte)function;
    }

    public int getFunction() {
        return this.header[3] & 0xFF;
    }

    public String getSxfyRsp() {
        return this.isSecondary() ? this.getSxFx() : String.format("S%dF%d", this.getStream(), this.getFunction() + 1);
    }

    public void setSystembyte(long systembyte) {
        byte[] bs = ObjectConverter.uint4ToByte(String.valueOf(systembyte));
        System.arraycopy(bs, 0, this.header, 6, 4);
    }

    public long getSystembyte() {
        byte[] bs = new byte[8];
        System.arraycopy(this.header, 6, bs, 4, 4);
        return BytesConverter.byte2Long(bs);
    }

    public void setStype(int stype) {
        this.header[0] = -1;
        this.header[1] = -1;
        this.header[5] = (byte)stype;
    }

    public int getStype() {
        return this.header[5] & 0xFF;
    }

    public void setReasonCode(int reasonCode) {
        this.header[3] = (byte)reasonCode;
    }

    public int getReasonCode() {
        return this.header[3] & 0xFF;
    }

    public boolean isSecondary() {
        return this.getFunction() % 2 == 0;
    }

    public boolean isControlMessage() {
        return 0 != this.getStype();
    }

    public boolean isHsmsSelectReqMessage() {
        return 1 == this.getStype();
    }

    public boolean isHsmsSelectRspMessage() {
        return 2 == this.getStype();
    }

    public boolean isSeparateReqMessage() {
        return 9 == this.getStype();
    }

    public boolean isWbit() {
        return (this.header[2] & 0xFF) > 128;
    }

    public String getWbitString() {
        return this.isWbit() ? " W" : "";
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public byte[] getHeader() {
        return this.header;
    }

    public void setHeader(byte[] header) {
        this.header = header;
    }

    private String getControlMessageType() {
        switch (this.header[5]) {
            case 1: {
                return "(Select.req)";
            }
            case 2: {
                return "(Select.rsp)";
            }
            case 5: {
                return "(Linktest.req)";
            }
            case 6: {
                return "(Linktest.rsp)";
            }
            case 7: {
                return "(Reject.req)";
            }
            case 9: {
                return "(Separate.req)";
            }
        }
        return "(Unknown control message)";
    }

    @Override
    public String logFormat() {
        if (!this.isHsms()) {
            return this.getLogTree();
        }
        return this.isControlMessage() ? this.getLogBytes() : this.getLogTree();
    }

    private String getLogTree() {
        int length = this.getLength() * 3;
        if (length > 0x100000) {
            length = 2048;
        }
        StringBuffer sb = new StringBuffer(length);
        sb.append(this.toStringHeader(this.isReceive() ? RECD : SEND));
        if (this.getChildren().size() > 0) {
            sb.append(ConstUtils.NEWLINE);
            sb.append(this.toStringBody());
        }
        return sb.toString();
    }

    public String logHeader() {
        return this.toStringHeader(this.isReceive() ? RECD : SEND);
    }

    private String toStringHeader(String arg) {
        return String.format("%sD%d %s:S%dF%d%s [%s] %s %s", arg, this.getDeviceId(), this.getName(), this.getStream(), this.getFunction(), this.getWbitString(), this.getSystembyte(), null == this.getId() ? "" : "(" + this.getId() + ")", this.getComment());
    }

    private String getLogBytes() {
        StringBuffer sb = new StringBuffer(this.getLength() * 3);
        sb.append(this.isReceive() ? RECD : SEND);
        for (byte b : this.header) {
            sb.append(StringUtils.toHex2String(b));
        }
        sb.append(this.getControlMessageType());
        return sb.toString();
    }

    public boolean isReceive() {
        return this.receive;
    }

    public void setReceive(boolean receive) {
        this.receive = receive;
    }

    @Override
    public String getName() {
        return this.name == null || this.name.trim().equals("") ? this.getSxFx() : this.name;
    }

    void getName(SFMessage recd) {
        if (this.name == null || this.name.trim().equals("")) {
            return;
        }
        this.aliasMessageName.getLinkedFormatName(recd);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public List<Format> getChildren() {
        return this.children;
    }

    public void setChildren(List<Format> children) {
        this.children = children;
    }

    @Override
    public Format add(Format format) {
        format.setMessage(this);
        this.addName(format);
        this.getChildren().add(format);
        format.setParent(this);
        return format;
    }

    public SFMessage fromLibrary(Document doc) {
        return (SFMessage)this.fromLibrary(doc.getRootElement());
    }

    @Override
    public Format fromLibrary(Element element) {
        this.setName(element.getName());
        this.setFunction(Integer.parseInt(element.getAttributeValue(FUNCTION)));
        this.setStream(Integer.parseInt(element.getAttributeValue(STREAM)));
        this.setWbit(Boolean.parseBoolean(element.getAttributeValue(WBIT)));
        this.setAutoreply(Boolean.parseBoolean(element.getAttributeValue(AUTOREPLY)));
        if (null != element.getAttributeValue(MSG_KIND)) {
            this.setMsgKind(Integer.parseInt(element.getAttributeValue(MSG_KIND)));
        }
        this.aliasMessageName.setLinkedFormatName(element);
        List children = element.getChildren();
        for (Element e : children) {
            Format format = Formatter.newInstance(e.getName());
            format.setMessage(this);
            format.fromLibrary(e);
            this.add(format);
        }
        return this;
    }

    @Override
    public int getType() {
        return 0;
    }

    public void decoding() {
        new FormatVisitor().decoding(this.getBody(), this);
    }

    public void encode() {
        this.setBody(new FormatVisitor().encodeBody(this.getChildren()));
    }

    public boolean isAutoreply() {
        return this.autoreply;
    }

    public void setAutoreply(boolean autoreply) {
        this.autoreply = autoreply;
    }

    public boolean isLongIdx() {
        return true;
    }

    public void setMsgKind(int msgKind) {
        this.msgKind = msgKind;
    }

    public int getMsgKind() {
        return this.msgKind;
    }

    @Override
    public int valueCopy(byte[] bs, int pos) {
        return 0;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Object getCorrelation() {
        return this.correlation;
    }

    public String getCorrelationForString() {
        if (this.hasCorrelation()) {
            return (String)this.getCorrelation();
        }
        throw new NullPointerException("Correlation is null");
    }

    public Document getCorrelationForDocument() {
        if (this.hasCorrelation()) {
            return (Document)this.getCorrelation();
        }
        throw new NullPointerException("Correlation is null");
    }

    public boolean hasCorrelation() {
        return null != this.getCorrelation();
    }

    public void setCorrelation(Object correlation) {
        this.correlation = correlation;
    }

    public byte[] getCheckSum() {
        int i;
        short chksum = 0;
        for (i = 0; i < 10; ++i) {
            chksum = (short)(chksum + (this.getHeader()[i] & 0xFF));
        }
        for (i = 0; i < this.getBody().length; ++i) {
            chksum = (short)(chksum + (this.getBody()[i] & 0xFF));
        }
        return ObjectConverter.short2Byte(chksum);
    }

    public void setChecksum(byte[] bs) {
        this.checkSum = bs;
    }

    public boolean isRightChecksum() {
        byte[] calc = this.getCheckSum();
        return calc[0] == this.checkSum[0] && calc[1] == this.checkSum[1];
    }

    public SFMessage allocateSecs(SFMessage m, byte[] total) {
        this.body = new byte[total.length - 10];
        System.arraycopy(total, 0, this.header, 0, 10);
        System.arraycopy(total, 10, this.body, 0, this.body.length);
        return m;
    }

    public SFMessage allocateHsms(SFMessage m, byte[] total) {
        this.body = new byte[total.length - 10];
        System.arraycopy(total, 0, this.header, 0, 10);
        System.arraycopy(total, 10, this.body, 0, this.body.length);
        return m;
    }

    public byte[] makeHsmsBytesAll() {
        MemoryBuffer mb = new MemoryBuffer(this.getLength() + 4);
        mb.appendBeInt(this.getLength());
        mb.append(this.getHeader());
        mb.append(this.getBody());
        return mb.toBytes();
    }

    public byte[] makeSecsBytesAll() {
        byte[] bs = new byte[this.getLength() + 3];
        bs[0] = (byte)this.getLength();
        System.arraycopy(this.getHeader(), 0, bs, 1, 10);
        System.arraycopy(this.getBody(), 0, bs, 11, this.getBody().length);
        System.arraycopy(this.getCheckSum(), 0, bs, this.getBody().length + 11, 2);
        return bs;
    }

    public boolean isHsms() {
        return this.hsms;
    }

    public void setHsms(boolean hsms) {
        this.hsms = hsms;
    }

    public boolean isWellKnown(SFMessage checkIt) {
        if (this.getChildren().size() != checkIt.getChildren().size()) {
            this.setComment("xxxxx List Count Not Equal");
            return false;
        }
        return new FormatVisitor().isWellKnown(this, checkIt);
    }

    @Override
    protected byte[] encodeOneValue(String iter) {
        Assert.fail("not supported method", new Object[0]);
        return null;
    }

    public int getReqTimeout() {
        return this.reqTimeout;
    }

    public void setReqTimeout(int reqTimeout) {
        this.reqTimeout = reqTimeout;
    }

    public void setUnkCode(int unkCode) {
        this.unkCode = unkCode;
    }

    public int getUnkCode() {
        return this.unkCode;
    }
}

