/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.hsms.format;

import kr.floware.hsms.format.AbstractFormat;
import kr.floware.hsms.format.BytesConverter;
import kr.floware.hsms.format.ObjectConverter;
import kr.floware.utils.Assert;

public class Uint2Format
extends AbstractFormat {
    public static final int TYPE = 168;

    public Uint2Format() {
    }

    public Uint2Format(int value) {
        this(1, "", value);
    }

    public Uint2Format(String name, int value) {
        this(1, name, value);
    }

    @Override
    protected int multiple() {
        return 2;
    }

    public Uint2Format(int length, String name, int value) {
        if (value < 0 || value > 65536) {
            Assert.fail("U2 Format Support 0~65536", new Object[0]);
        }
        this.setName(name);
        this.setLength(length);
        this.setValue(String.valueOf(value));
    }

    @Override
    public int getType() {
        return 168;
    }

    @Override
    public String getLogType() {
        return "U2";
    }

    @Override
    protected byte[] encodeOneValue(String iter) {
        int v = Integer.parseInt(iter);
        byte[] temp = new byte[2];
        byte[] bs = ObjectConverter.int2Byte(v);
        System.arraycopy(bs, 2, temp, 0, 2);
        return temp;
    }

    @Override
    public int valueCopy(byte[] bs, int pos) {
        int length = this.getLength() * 2;
        byte[] bs2 = new byte[length];
        System.arraycopy(bs, pos, bs2, 0, length);
        this.setValue(BytesConverter.byte2Uint2(bs2));
        return pos += length;
    }
}

