/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.hsms.format;

import kr.floware.hsms.format.AbstractFormat;
import kr.floware.hsms.format.BytesConverter;
import kr.floware.hsms.format.ObjectConverter;
import kr.floware.utils.Assert;

public class Uint4Format
extends AbstractFormat {
    public static final int TYPE = 176;

    public Uint4Format() {
    }

    public Uint4Format(int value) {
        this((long)value);
    }

    public Uint4Format(long value) {
        Assert.isFalse(value < 0L, "U4 Format Support 0~%d, input %d", -2, value);
        this.setLength(1);
        this.setValue(String.valueOf(value));
    }

    @Override
    protected int multiple() {
        return 4;
    }

    @Override
    public int getType() {
        return 176;
    }

    @Override
    public String getLogType() {
        return "U4";
    }

    @Override
    protected byte[] encodeOneValue(String iter) {
        long v = Long.parseLong(iter);
        byte[] temp = new byte[4];
        byte[] bs = ObjectConverter.long2Byte(v);
        System.arraycopy(bs, 4, temp, 0, 4);
        return temp;
    }

    @Override
    public int valueCopy(byte[] bs, int pos) {
        int length = this.getLength() * 4;
        byte[] bs2 = new byte[length];
        System.arraycopy(bs, pos, bs2, 0, length);
        this.setValue(BytesConverter.byte2Uint4(bs2));
        return pos += length;
    }
}

