/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.hsms.format;

import kr.floware.hsms.format.AbstractFormat;
import kr.floware.hsms.format.BytesConverter;
import kr.floware.hsms.format.ObjectConverter;
import kr.floware.utils.Assert;

public class Uint8Format
extends AbstractFormat {
    public static final int TYPE = 160;

    public Uint8Format() {
    }

    public Uint8Format(long value) {
        Assert.isFalse(value < 0L, "U8 Format Support Greater Than 0, input %d", value);
        this.setLength(1);
        this.setValue(String.valueOf(value));
    }

    @Override
    public int getType() {
        return 160;
    }

    @Override
    protected int multiple() {
        return 8;
    }

    @Override
    public String getLogType() {
        return "U8";
    }

    @Override
    protected byte[] encodeOneValue(String iter) {
        long v = Long.parseLong(iter);
        Assert.isTrue(v >= 0L, "%s value must >0", this.getName());
        return ObjectConverter.long2Byte(v);
    }

    @Override
    public int valueCopy(byte[] bs, int pos) {
        int length = this.getLength() * 8;
        byte[] bs2 = new byte[length];
        System.arraycopy(bs, pos, bs2, 0, length);
        this.setValue(BytesConverter.byte2Uint8(bs2));
        return pos += length;
    }
}

