/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.jdbc;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import kr.floware.jdbc.NssIgnore;
import kr.floware.jdbc.NssModel;
import kr.floware.jdbc.NssTrx;
import kr.floware.utils.Assert;
import kr.floware.utils.ClassUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class NssTemplate<T>
implements InitializingBean {
    private PlatformTransactionManager ptm;
    private JdbcTemplate jdbcTemplate;
    static DefaultTransactionDefinition trxDef = new DefaultTransactionDefinition(0);
    private HashMap<String, PropertyDescriptor> mappedProps = new HashMap();
    final String MYSQL = "MySQL";
    final String ORACLE = "Oracle";
    final String MSSQL = "Microsoft SQL Server";

    @Autowired
    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.ptm = transactionManager;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    @Autowired
    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public void afterPropertiesSet() throws Exception {
        PropertyDescriptor[] pds;
        for (PropertyDescriptor pd : pds = BeanUtils.getPropertyDescriptors(this.getGenericType())) {
            Method method = pd.getReadMethod();
            if (pd.getReadMethod() == null || !ClassUtils.isPublicMethod(method) || ClassUtils.isGetClassMethod(method) || method.isAnnotationPresent(NssIgnore.class)) continue;
            pd.setDisplayName(pd.getName().substring(0, 1).toUpperCase(Locale.US) + pd.getName().substring(1));
            this.mappedProps.put(pd.getReadMethod().getName(), pd);
        }
    }

    public NssTrx begin() {
        Assert.notNull(this.ptm, "TransactionManager is null", new Object[0]);
        NssTrx nt = new NssTrx();
        nt.setTransactionStatus(this.ptm.getTransaction((TransactionDefinition)trxDef));
        return nt;
    }

    void chkTrxState(NssTrx nt) {
        Assert.notNull(this.ptm, "TransactionManager is null", new Object[0]);
        Assert.notNull(nt, "NssTrx is null", new Object[0]);
        Assert.notNull(nt.getTransactionStatus(), "NssTrx.ITS is null", new Object[0]);
        Assert.isFalse(nt.getTransactionStatus().isCompleted(), "Transaction already completed", new Object[0]);
    }

    public void commit(NssTrx nt) {
        this.chkTrxState(nt);
        this.ptm.commit(nt.getTransactionStatus());
    }

    public void rollback(NssTrx nt) {
        if (null == nt) {
            return;
        }
        this.chkTrxState(nt);
        this.ptm.rollback(nt.getTransactionStatus());
    }

    public void add(T o) {
        Class<T> clz = this.getGenericType();
        NssModel nm = clz.getAnnotation(NssModel.class);
        StringBuffer sb = new StringBuffer(256);
        sb.append("INSERT INTO ");
        String table = o.getClass().getAnnotation(NssModel.class).table();
        sb.append(table);
        sb.append(" (");
        ArrayList<Object> vList = new ArrayList<Object>();
        for (PropertyDescriptor pd : this.mappedProps.values()) {
            Object objV;
            Method method = pd.getReadMethod();
            if (pd.getDisplayName().equals(nm.seqNo()) || (objV = ClassUtils.invoke(o, method)) instanceof Collection) continue;
            sb.append(pd.getDisplayName());
            sb.append(",");
            if (objV.getClass().isEnum()) {
                vList.add(objV.toString());
                continue;
            }
            vList.add(objV);
        }
        if (nm.seqNo().length() > 0 && this.getDbType().equals("Oracle")) {
            sb.append(nm.seqNo() + ",");
        }
        sb.delete(sb.length() - 1, sb.length());
        sb.append(") VALUES (");
        for (int i = 0; i < vList.size(); ++i) {
            sb.append("?,");
        }
        if (nm.seqNo().length() > 0 && this.getDbType().equals("Oracle")) {
            sb.append(nm.seqNo() + ".NEXTVAL,");
        }
        sb.delete(sb.length() - 1, sb.length());
        sb.append(")");
        this.getJdbcTemplate().update(sb.toString(), vList.toArray());
    }

    private String getDbType() {
        String dbtype = "";
        try {
            dbtype = this.getJdbcTemplate().getDataSource().getConnection().getMetaData().getDatabaseProductName();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return dbtype;
    }

    public List<T> list(String cmd, Object ... args) {
        Class<T> clz = this.getGenericType();
        return this.getJdbcTemplate().query(cmd, args, (RowMapper)new BeanPropertyRowMapper(clz));
    }

    public void update(String cmd, Object ... args) {
        this.getJdbcTemplate().update(cmd, args);
    }

    public int getInt(String sql, Object ... objects) {
        return (Integer)this.getJdbcTemplate().queryForObject(sql, Integer.class, objects);
    }

    public T get(Object key) {
        Class<T> clz = this.getGenericType();
        NssModel nm = clz.getAnnotation(NssModel.class);
        String table = nm.table();
        String keyName = nm.key();
        String cmd = "SELECT * FROM " + table + " WHERE " + keyName + "=?";
        try {
            return (T)this.getJdbcTemplate().queryForObject(cmd, new Object[]{key}, (RowMapper)new BeanPropertyRowMapper(clz));
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    private Class<T> getGenericType() {
        Type type = this.getClass().getGenericSuperclass();
        ParameterizedType paramType = (ParameterizedType)type;
        return (Class)paramType.getActualTypeArguments()[0];
    }
}

