/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.plc;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import kr.floware.plc.BitBlock;
import kr.floware.plc.PlcBlock;
import kr.floware.plc.PlcToken;
import kr.floware.plc.WordBlock;
import kr.floware.utils.Assert;

public abstract class PlcGroup {
    private Map<String, PlcBlock> addBlocks = new HashMap<String, PlcBlock>();
    private List<PlcBlock> orders = new CopyOnWriteArrayList<PlcBlock>();
    private List<PlcToken> tokens = new ArrayList<PlcToken>();
    private String name = "";
    private boolean bitType = false;
    private boolean firstChanged = true;
    private int gapSize = 200;

    public Map<String, PlcBlock> getAddedBlocks() {
        return this.addBlocks;
    }

    public int getGapSize() {
        return this.gapSize;
    }

    public void setGapSize(int gapSize) {
        this.gapSize = gapSize;
    }

    public List<PlcBlock> getOrders() {
        return this.orders;
    }

    public List<PlcToken> getTokens() {
        return this.tokens;
    }

    public boolean isFirstChanged() {
        return this.firstChanged;
    }

    public void setFirstChanged(boolean firstChanged) {
        this.firstChanged = firstChanged;
    }

    public boolean isBitType() {
        return this.bitType;
    }

    public void setBitType(boolean bitType) {
        this.bitType = bitType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addBlock(PlcBlock plcBlock) {
        Assert.isTrue(!this.addBlocks.containsKey(plcBlock.getName()), String.format("Duplicate block name %s", plcBlock.getName()), new Object[0]);
        if (plcBlock instanceof BitBlock) {
            BitBlock bit = (BitBlock)plcBlock;
            this.addBlocks.put(plcBlock.getName(), bit.copy());
        } else {
            WordBlock wd = (WordBlock)plcBlock;
            this.addBlocks.put(plcBlock.getName(), wd.copy());
        }
    }

    public void arrange() {
        List ords;
        if (this.isBitType()) {
            ords = this.addBlocks.values().stream().map(BitBlock.class::cast).sorted(Comparator.comparing(PlcBlock::getAddress).thenComparing(BitBlock::getBitIndex)).collect(Collectors.toList());
            this.orders = new CopyOnWriteArrayList(ords);
        } else {
            ords = this.addBlocks.values().stream().map(WordBlock.class::cast).sorted(Comparator.comparing(PlcBlock::getAddress).thenComparing(PlcBlock::getPoint)).collect(Collectors.toList());
            this.orders = new CopyOnWriteArrayList(ords);
        }
        for (int i = 0; i < this.getOrders().size(); ++i) {
            PlcBlock blk = this.getOrders().get(i);
            blk.setPre(i == 0 ? blk : this.getOrders().get(i - 1));
            blk.setNext(i == this.getOrders().size() - 1 ? blk : this.getOrders().get(i + 1));
        }
        int tokAddr = this.getOrders().get(0).getAddress();
        for (PlcBlock block : this.getOrders()) {
            if (!block.needNewToken(this.getGapSize())) continue;
            this.tokens.add(new PlcToken(tokAddr, block.getAddress() + block.getPoint() - tokAddr));
            tokAddr = block.getNext().getAddress();
        }
        this.getOrders().forEach(x -> x.setPlcGroup(this));
    }

    public String toString() {
        return String.format("Group %s bitType:%s blockCount:%d", this.getName(), this.isBitType(), this.getAddedBlocks().size());
    }
}

