/*
 * Decompiled with CFR 0.152.
 */
package kr.floware.quartz;

import java.util.Properties;
import kr.floware.logging.Logger;
import kr.floware.quartz.QuartzAction;
import kr.floware.utils.Assert;
import kr.floware.utils.ClassUtils;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.simpl.SimpleThreadPool;

public class QuartzUtils {
    private static Logger logger = Logger.getLogger();
    private static StdSchedulerFactory factory = new StdSchedulerFactory();
    private static Scheduler sched;
    private static final String PROP_THREAD_COUNT = "org.quartz.threadPool.threadCount";

    public static void init(int threadcount) {
        try {
            Assert.isNull(sched, "QuartzUtils Already Inited", new Object[0]);
            Properties props = new Properties();
            props.put("org.quartz.threadPool.class", SimpleThreadPool.class.getName());
            props.put(PROP_THREAD_COUNT, String.valueOf(threadcount));
            factory.initialize(props);
            sched = factory.getScheduler();
            sched.start();
        }
        catch (Exception e) {
            logger.e(e);
            Assert.fail(e);
        }
    }

    public static void invoke(String jobName, String expression, Object target, String method) {
        try {
            Assert.notNull(sched, "QuartzUtils Not Init", new Object[0]);
            CronTrigger ct = new CronTrigger(jobName, null);
            ct.setCronExpression(expression);
            JobDetail job = new JobDetail(jobName, null, QuzJobDetailReflection.class);
            job.getJobDataMap().put((Object)"target", target);
            job.getJobDataMap().put("method", method);
            QuartzUtils.stopSchedule(jobName);
            sched.scheduleJob(job, (Trigger)ct);
        }
        catch (Exception e) {
            logger.e(e);
            Assert.fail(e);
        }
    }

    public static void invoke(String jobName, String expression, QuartzAction delegate) {
        try {
            Assert.notNull(sched, "QuartzUtils Not Init", new Object[0]);
            CronTrigger ct = new CronTrigger(jobName, null);
            ct.setCronExpression(expression);
            JobDetail job = new JobDetail(jobName, null, QuzJobDetailInterface.class);
            job.getJobDataMap().put((Object)"dlg", (Object)delegate);
            QuartzUtils.stopSchedule(jobName);
            sched.scheduleJob(job, (Trigger)ct);
        }
        catch (Exception e) {
            logger.e(e);
            Assert.fail(e);
        }
    }

    public static boolean stopSchedule(String jobName) {
        try {
            boolean bl = sched.unscheduleJob(jobName, null);
            if (bl) {
                logger.i("QuartzUtils Schedule Stopped [%s]", jobName);
            }
            return bl;
        }
        catch (Exception e) {
            logger.e(e);
            Assert.fail(e);
            return false;
        }
    }

    public static class QuzJobDetailReflection
    implements Job {
        public void execute(JobExecutionContext arg0) throws JobExecutionException {
            try {
                Object target = arg0.getJobDetail().getJobDataMap().get((Object)"target");
                String methodName = (String)arg0.getJobDetail().getJobDataMap().get((Object)"method");
                ClassUtils.invoke(target, methodName, new Object[0]);
            }
            catch (Exception e) {
                logger.e(e);
            }
        }
    }

    public static class QuzJobDetailInterface
    implements Job {
        public void execute(JobExecutionContext arg0) throws JobExecutionException {
            QuartzAction a = (QuartzAction)arg0.getJobDetail().getJobDataMap().get((Object)"dlg");
            a.quartzDoIt(arg0.getJobDetail().getName());
        }
    }
}

